/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.ElasticSearchIndexer;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.events.EventListener;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.elasticsearch.v7.ElasticSearchQuotaConfiguration;
import org.apache.james.quota.search.elasticsearch.v7.ElasticSearchQuotaSearcher;
import org.apache.james.quota.search.elasticsearch.v7.QuotaSearchIndexCreationUtil;
import org.apache.james.quota.search.elasticsearch.v7.UserRoutingKeyFactory;
import org.apache.james.quota.search.elasticsearch.v7.events.ElasticSearchQuotaMailboxListener;
import org.apache.james.quota.search.elasticsearch.v7.json.QuotaRatioToElasticSearchJson;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchQuotaSearcherModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchQuotaSearcherModule.class);

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(ElasticSearchQuotaMailboxListener.class);
    }

    @Provides
    @Singleton
    public QuotaSearcher provideSearcher(ReactorElasticSearchClient client, ElasticSearchQuotaConfiguration configuration) {
        return new ElasticSearchQuotaSearcher(client, configuration.getReadAliasQuotaRatioName());
    }

    @Provides
    @Singleton
    private ElasticSearchQuotaConfiguration getElasticSearchQuotaConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("elasticsearch");
            return ElasticSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find elasticsearch configuration file. Providing a default ElasticSearchQuotaConfiguration");
            return ElasticSearchQuotaConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    public ElasticSearchQuotaMailboxListener provideListener(ReactorElasticSearchClient client, ElasticSearchQuotaConfiguration configuration) {
        return new ElasticSearchQuotaMailboxListener(new ElasticSearchIndexer(client, configuration.getWriteAliasQuotaRatioName()), new QuotaRatioToElasticSearchJson(), (RoutingKey.Factory)new UserRoutingKeyFactory());
    }

    @ProvidesIntoSet
    InitializationOperation createIndex(ElasticSearchQuotaIndexCreator instance) {
        return InitilizationOperationBuilder.forClass(ElasticSearchQuotaIndexCreator.class).init(instance::createIndex);
    }

    static class ElasticSearchQuotaIndexCreator
    implements Startable {
        private final ElasticSearchConfiguration configuration;
        private final ElasticSearchQuotaConfiguration quotaConfiguration;
        private final ReactorElasticSearchClient client;

        @Inject
        ElasticSearchQuotaIndexCreator(ElasticSearchConfiguration configuration, ElasticSearchQuotaConfiguration quotaConfiguration, ReactorElasticSearchClient client) {
            this.configuration = configuration;
            this.quotaConfiguration = quotaConfiguration;
            this.client = client;
        }

        void createIndex() throws IOException {
            QuotaSearchIndexCreationUtil.prepareClient((ReactorElasticSearchClient)this.client, (AliasName)this.quotaConfiguration.getReadAliasQuotaRatioName(), (AliasName)this.quotaConfiguration.getWriteAliasQuotaRatioName(), (IndexName)this.quotaConfiguration.getIndexQuotaRatioName(), (ElasticSearchConfiguration)this.configuration);
        }
    }
}

