/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.util.mime.MessageContentExtractor;
import org.apache.james.webadmin.dto.HeadersDto;
import org.apache.james.webadmin.dto.InaccessibleFieldException;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;

public class MailDto {
    private final String name;
    private final Optional<String> sender;
    private final List<String> recipients;
    private final Optional<String> error;
    private final Optional<String> state;
    private final Optional<String> remoteHost;
    private final Optional<String> remoteAddr;
    private final Optional<Date> lastUpdated;
    private final Optional<ImmutableMap<String, String>> attributes;
    private final Optional<ImmutableMap<String, HeadersDto>> perRecipientsHeaders;
    private final Optional<HeadersDto> headers;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;
    private final Optional<Long> messageSize;

    public static MailDto fromMail(Mail mail, Set<AdditionalField> additionalFields) throws MessagingException, InaccessibleFieldException {
        Optional<MessageContentExtractor.MessageContent> messageContent = MailDto.fetchMessage(additionalFields, mail);
        return new MailDto(mail.getName(), mail.getMaybeSender().asOptional().map(MailAddress::asString), (List)mail.getRecipients().stream().map(MailAddress::asString).collect(Guavate.toImmutableList()), Optional.ofNullable(mail.getErrorMessage()), Optional.ofNullable(mail.getState()), Optional.ofNullable(mail.getRemoteHost()), Optional.ofNullable(mail.getRemoteAddr()), Optional.ofNullable(mail.getLastUpdated()), MailDto.fetchAttributes(additionalFields, mail), MailDto.fetchPerRecipientsHeaders(additionalFields, mail), MailDto.fetchHeaders(additionalFields, mail), MailDto.fetchTextBody(additionalFields, messageContent), MailDto.fetchHtmlBody(additionalFields, messageContent), MailDto.fetchMessageSize(additionalFields, mail));
    }

    private static Optional<Long> fetchMessageSize(Set<AdditionalField> additionalFields, Mail mail) throws InaccessibleFieldException {
        if (!additionalFields.contains((Object)AdditionalField.MESSAGE_SIZE)) {
            return Optional.empty();
        }
        try {
            return Optional.of(mail.getMessageSize());
        }
        catch (MessagingException e) {
            throw new InaccessibleFieldException(AdditionalField.MESSAGE_SIZE, (Exception)((Object)e));
        }
    }

    private static Optional<String> fetchTextBody(Set<AdditionalField> additionalFields, Optional<MessageContentExtractor.MessageContent> messageContent) throws InaccessibleFieldException {
        if (!additionalFields.contains((Object)AdditionalField.TEXT_BODY)) {
            return Optional.empty();
        }
        return messageContent.flatMap(MessageContentExtractor.MessageContent::getTextBody);
    }

    private static Optional<String> fetchHtmlBody(Set<AdditionalField> additionalFields, Optional<MessageContentExtractor.MessageContent> messageContent) throws InaccessibleFieldException {
        if (!additionalFields.contains((Object)AdditionalField.HTML_BODY)) {
            return Optional.empty();
        }
        return messageContent.flatMap(MessageContentExtractor.MessageContent::getHtmlBody);
    }

    private static Optional<MessageContentExtractor.MessageContent> fetchMessage(Set<AdditionalField> additionalFields, Mail mail) throws InaccessibleFieldException {
        if (!additionalFields.contains((Object)AdditionalField.TEXT_BODY) && !additionalFields.contains((Object)AdditionalField.HTML_BODY)) {
            return Optional.empty();
        }
        try {
            MessageContentExtractor extractor = new MessageContentExtractor();
            return Optional.ofNullable(mail.getMessage()).map(Throwing.function(MailDto::convertMessage).sneakyThrow()).map(Throwing.function(arg_0 -> ((MessageContentExtractor)extractor).extract(arg_0)).sneakyThrow());
        }
        catch (MessagingException e) {
            if (additionalFields.contains((Object)AdditionalField.TEXT_BODY)) {
                throw new InaccessibleFieldException(AdditionalField.TEXT_BODY, (Exception)((Object)e));
            }
            throw new InaccessibleFieldException(AdditionalField.HTML_BODY, (Exception)((Object)e));
        }
    }

    private static Message convertMessage(MimeMessage message) throws IOException, MessagingException {
        return Message.Builder.of().use(MimeConfig.PERMISSIVE).parse((InputStream)new MimeMessageInputStream(message)).build();
    }

    private static Optional<HeadersDto> fetchHeaders(Set<AdditionalField> additionalFields, Mail mail) throws InaccessibleFieldException {
        if (!additionalFields.contains((Object)AdditionalField.HEADERS)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(mail.getMessage()).map(Throwing.function(MailDto::extractHeaders).sneakyThrow());
        }
        catch (MessagingException e) {
            throw new InaccessibleFieldException(AdditionalField.HEADERS, (Exception)((Object)e));
        }
    }

    private static HeadersDto extractHeaders(MimeMessage message) throws MessagingException {
        return new HeadersDto((ImmutableListMultimap<String, String>)((ImmutableListMultimap)Collections.list(message.getAllHeaders()).stream().collect(Guavate.toImmutableListMultimap(Header::getName, header -> MimeUtil.unscrambleHeaderValue((String)header.getValue())))));
    }

    private static Optional<ImmutableMap<String, HeadersDto>> fetchPerRecipientsHeaders(Set<AdditionalField> additionalFields, Mail mail) {
        if (!additionalFields.contains((Object)AdditionalField.PER_RECIPIENTS_HEADERS)) {
            return Optional.empty();
        }
        Multimap headersByRecipient = mail.getPerRecipientSpecificHeaders().getHeadersByRecipient();
        return Optional.of((ImmutableMap)headersByRecipient.keySet().stream().collect(Guavate.toImmutableMap(MailAddress::asString, address -> MailDto.fetchPerRecipientHeader((Multimap<MailAddress, PerRecipientHeaders.Header>)headersByRecipient, address))));
    }

    private static HeadersDto fetchPerRecipientHeader(Multimap<MailAddress, PerRecipientHeaders.Header> headersByRecipient, MailAddress address) {
        return new HeadersDto((ImmutableListMultimap<String, String>)((ImmutableListMultimap)headersByRecipient.get((Object)address).stream().collect(Guavate.toImmutableListMultimap(PerRecipientHeaders.Header::getName, PerRecipientHeaders.Header::getValue))));
    }

    private static Optional<ImmutableMap<String, String>> fetchAttributes(Set<AdditionalField> additionalFields, Mail mail) {
        if (!additionalFields.contains((Object)AdditionalField.ATTRIBUTES)) {
            return Optional.empty();
        }
        return Optional.of((ImmutableMap)mail.attributes().collect(Guavate.toImmutableMap(attribute -> attribute.getName().asString(), attribute -> attribute.getValue().value().toString())));
    }

    public MailDto(String name, Optional<String> sender, List<String> recipients, Optional<String> error, Optional<String> state, Optional<String> remoteHost, Optional<String> remoteAddr, Optional<Date> lastUpdated, Optional<ImmutableMap<String, String>> attributes, Optional<ImmutableMap<String, HeadersDto>> perRecipientsHeaders, Optional<HeadersDto> headers, Optional<String> textBody, Optional<String> htmlBody, Optional<Long> messageSize) {
        this.name = name;
        this.sender = sender;
        this.recipients = recipients;
        this.error = error;
        this.state = state;
        this.remoteHost = remoteHost;
        this.remoteAddr = remoteAddr;
        this.lastUpdated = lastUpdated;
        this.attributes = attributes;
        this.perRecipientsHeaders = perRecipientsHeaders;
        this.headers = headers;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.messageSize = messageSize;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getSender() {
        return this.sender;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<String> getState() {
        return this.state;
    }

    public Optional<String> getRemoteHost() {
        return this.remoteHost;
    }

    public Optional<String> getRemoteAddr() {
        return this.remoteAddr;
    }

    public Optional<Date> getLastUpdated() {
        return this.lastUpdated;
    }

    public Optional<ImmutableMap<String, String>> getAttributes() {
        return this.attributes;
    }

    public Optional<ImmutableMap<String, HeadersDto>> getPerRecipientsHeaders() {
        return this.perRecipientsHeaders;
    }

    public Optional<HeadersDto> getHeaders() {
        return this.headers;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public Optional<Long> getMessageSize() {
        return this.messageSize;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailDto) {
            MailDto mailDto = (MailDto)o;
            return Objects.equals(this.name, mailDto.name) && Objects.equals(this.sender, mailDto.sender) && Objects.equals(this.recipients, mailDto.recipients) && Objects.equals(this.error, mailDto.error) && Objects.equals(this.state, mailDto.state) && Objects.equals(this.remoteHost, mailDto.remoteHost) && Objects.equals(this.remoteAddr, mailDto.remoteAddr) && Objects.equals(this.lastUpdated, mailDto.lastUpdated) && Objects.equals(this.attributes, mailDto.attributes) && Objects.equals(this.perRecipientsHeaders, mailDto.perRecipientsHeaders) && Objects.equals(this.headers, mailDto.headers) && Objects.equals(this.textBody, mailDto.textBody) && Objects.equals(this.htmlBody, mailDto.htmlBody) && Objects.equals(this.messageSize, mailDto.messageSize);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.sender, this.recipients, this.error, this.state, this.remoteHost, this.remoteAddr, this.lastUpdated, this.attributes, this.perRecipientsHeaders, this.headers, this.textBody, this.htmlBody, this.messageSize);
    }

    public static enum AdditionalField {
        ATTRIBUTES("attributes"),
        PER_RECIPIENTS_HEADERS("perRecipientsHeaders"),
        TEXT_BODY("textBody"),
        HTML_BODY("htmlBody"),
        HEADERS("headers"),
        MESSAGE_SIZE("messageSize");

        private final String fieldName;

        public static Optional<AdditionalField> find(String fieldName) {
            return Arrays.stream(AdditionalField.values()).filter(value -> value.fieldName.equalsIgnoreCase(fieldName)).findAny();
        }

        private AdditionalField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getName() {
            return this.fieldName;
        }
    }
}

