/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.BucketNameResolver;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.util.DataChunker;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.pool.InstrumentedPool;
import reactor.pool.PoolBuilder;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3BlobStoreDAO
implements BlobStoreDAO,
Startable,
Closeable {
    private static final int CHUNK_SIZE = 0x100000;
    private static final int EMPTY_BUCKET_BATCH_SIZE = 1000;
    private static final int FILE_THRESHOLD = 102400;
    private static final Duration FIRST_BACK_OFF = Duration.ofMillis(100L);
    private static final Duration FOREVER = Duration.ofMillis(Long.MAX_VALUE);
    private static final boolean LAZY = false;
    private static final int MAX_RETRIES = 5;
    private final InstrumentedPool<S3AsyncClient> clientPool;
    private final BucketNameResolver bucketNameResolver;

    @Inject
    S3BlobStoreDAO(S3BlobStoreConfiguration configuration) {
        AwsS3AuthConfiguration authConfiguration = configuration.getSpecificAuthConfiguration();
        S3Configuration pathStyleAccess = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build();
        Callable<S3AsyncClient> clientCreator = () -> (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)authConfiguration.getAccessKeyId(), (String)authConfiguration.getSecretKey())))).httpClientBuilder((SdkAsyncHttpClient.Builder)NettyNioAsyncHttpClient.builder().maxConcurrency(Integer.valueOf(100)).maxPendingConnectionAcquires(Integer.valueOf(10000)))).endpointOverride(authConfiguration.getEndpoint())).region(configuration.getRegion().asAws())).serviceConfiguration(pathStyleAccess)).build();
        this.clientPool = PoolBuilder.from((Publisher)Mono.fromCallable(clientCreator)).acquisitionScheduler(Schedulers.elastic()).destroyHandler(client -> Mono.fromRunnable(() -> ((S3AsyncClient)client).close())).maxPendingAcquireUnbounded().sizeUnbounded().fifo();
        this.bucketNameResolver = BucketNameResolver.builder().prefix(configuration.getBucketPrefix()).namespace(configuration.getNamespace()).build();
    }

    public void start() {
        this.clientPool.warmup().block();
    }

    @Override
    @PreDestroy
    public void close() {
        this.clientPool.dispose();
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return (InputStream)this.getObject(resolvedBucketName, blobId).map(response -> ReactorUtils.toInputStream(response.flux)).onErrorMap(NoSuchBucketException.class, e -> new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e)).onErrorMap(NoSuchKeyException.class, e -> new ObjectNotFoundException("Blob not found " + resolvedBucketName.asString(), (Throwable)e)).block();
    }

    private Mono<FluxResponse> getObject(BucketName bucketName, BlobId blobId) {
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.getObject(builder -> builder.bucket(bucketName.asString()).key(blobId.asString()), (AsyncResponseTransformer)new AsyncResponseTransformer<GetObjectResponse, FluxResponse>(){
            FluxResponse response;

            public CompletableFuture<FluxResponse> prepare() {
                this.response = new FluxResponse();
                return this.response.supportingCompletableFuture;
            }

            public void onResponse(GetObjectResponse response) {
                this.response.sdkResponse = response;
            }

            public void exceptionOccurred(Throwable error) {
                this.response.supportingCompletableFuture.completeExceptionally(error);
            }

            public void onStream(SdkPublisher<ByteBuffer> publisher) {
                this.response.flux = Flux.from(publisher);
                this.response.supportingCompletableFuture.complete(this.response);
            }
        }))).next();
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.getObject(builder -> builder.bucket(resolvedBucketName.asString()).key(blobId.asString()), AsyncResponseTransformer.toBytes()))).next().onErrorMap(NoSuchBucketException.class, e -> new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e)).onErrorMap(NoSuchKeyException.class, e -> new ObjectNotFoundException("Blob not found " + resolvedBucketName.asString(), (Throwable)e)).map(BytesWrapper::asByteArray);
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.putObject(builder -> builder.bucket(resolvedBucketName.asString()).key(blobId.asString()).contentLength(Long.valueOf(data.length)), AsyncRequestBody.fromBytes((byte[])data)))).next().retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).then();
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        return this.uploadUsingFile(bucketName, blobId, inputStream);
    }

    private Mono<Void> uploadUsingFile(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        return Mono.using(() -> new FileBackedOutputStream(102400), fileBackedOutputStream -> Mono.fromCallable(() -> IOUtils.copy((InputStream)inputStream, (OutputStream)fileBackedOutputStream)).flatMap(ignore -> this.save(bucketName, blobId, fileBackedOutputStream.asByteSource())), (Consumer)Throwing.consumer(FileBackedOutputStream::reset), (boolean)false).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.using(() -> ((ByteSource)content).openStream(), stream -> this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.putObject(Throwing.consumer(builder -> builder.bucket(resolvedBucketName.asString()).contentLength(Long.valueOf(content.size())).key(blobId.asString())).sneakyThrow(), AsyncRequestBody.fromPublisher((Publisher)DataChunker.chunkStream((InputStream)stream, (int)0x100000))))).next(), (Consumer)Throwing.consumer(InputStream::close), (boolean)false).retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).onErrorMap(SdkClientException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).then();
    }

    private RetryBackoffSpec createBucketOnRetry(BucketName bucketName) {
        return RetryBackoffSpec.backoff((long)5L, (Duration)FIRST_BACK_OFF).maxAttempts(5L).doBeforeRetryAsync(retrySignal -> {
            if (retrySignal.failure() instanceof NoSuchBucketException) {
                return this.clientPool.withPoolable(client -> Mono.fromFuture((CompletableFuture)client.createBucket(builder -> builder.bucket(bucketName.asString()))).onErrorResume(BucketAlreadyOwnedByYouException.class, e -> Mono.empty())).next().then();
            }
            return Mono.error((Throwable)retrySignal.failure());
        });
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.deleteObject(delete -> delete.bucket(resolvedBucketName.asString()).key(blobId.asString())))).next().then().onErrorResume(NoSuchBucketException.class, e -> Mono.empty());
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.deleteResolvedBucket(resolvedBucketName);
    }

    private Mono<Void> deleteResolvedBucket(BucketName bucketName) {
        return this.emptyBucket(bucketName).onErrorResume(t -> Mono.just((Object)bucketName)).flatMap(ignore -> this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.deleteBucket(builder -> builder.bucket(bucketName.asString())))).next()).onErrorResume(t -> Mono.empty()).then();
    }

    private Mono<BucketName> emptyBucket(BucketName bucketName) {
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.listObjects(builder -> builder.bucket(bucketName.asString()))).flatMapIterable(ListObjectsResponse::contents)).window(1000).flatMap(this::buildListForBatch, 16).flatMap(identifiers -> this.deleteObjects(bucketName, (List<ObjectIdentifier>)identifiers), 16).then(Mono.just((Object)bucketName));
    }

    private Mono<List<ObjectIdentifier>> buildListForBatch(Flux<S3Object> batch) {
        return batch.map(element -> (ObjectIdentifier)ObjectIdentifier.builder().key(element.key()).build()).collect(Guavate.toImmutableList());
    }

    private Mono<DeleteObjectsResponse> deleteObjects(BucketName bucketName, List<ObjectIdentifier> identifiers) {
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> client.deleteObjects(builder -> builder.bucket(bucketName.asString()).delete(delete -> delete.objects((Collection)identifiers))))).next();
    }

    @VisibleForTesting
    public Mono<Void> deleteAllBuckets() {
        return this.clientPool.withPoolable(client -> Mono.fromFuture(() -> ((S3AsyncClient)client).listBuckets()).flatMapIterable(ListBucketsResponse::buckets).flatMap(bucket -> this.deleteResolvedBucket(BucketName.of((String)bucket.name())), 16)).then();
    }

    private static class FluxResponse {
        final CompletableFuture<FluxResponse> supportingCompletableFuture = new CompletableFuture();
        GetObjectResponse sdkResponse;
        Flux<ByteBuffer> flux;

        private FluxResponse() {
        }
    }
}

