/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.utils.GuiceProbe;

public class MailRepositoryProbeImpl
implements GuiceProbe {
    private final MailRepositoryStore repositoryStore;

    @Inject
    public MailRepositoryProbeImpl(MailRepositoryStore repositoryStore) {
        this.repositoryStore = repositoryStore;
    }

    public long getRepositoryMailCount(MailRepositoryUrl url) throws Exception {
        return this.repositoryStore.select(url).size();
    }

    public void createRepository(MailRepositoryUrl url) throws Exception {
        this.repositoryStore.select(url);
    }

    public List<MailKey> listMailKeys(MailRepositoryUrl url) throws Exception {
        return ImmutableList.copyOf((Iterator)this.repositoryStore.select(url).list());
    }

    public List<MailRepositoryUrl> listRepositoryUrls() {
        return (List)this.repositoryStore.getUrls().collect(Guavate.toImmutableList());
    }

    public MailRepositoryStore getMailRepositoryStore() {
        return this.repositoryStore;
    }
}

