/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.utils.GuiceProbe;

public class GuiceProbeProvider {
    private final Map<Class<GuiceProbe>, GuiceProbe> registry;

    @Inject
    public GuiceProbeProvider(Set<GuiceProbe> guiceProbes) {
        this.registry = (Map)guiceProbes.stream().collect(Guavate.toImmutableMap(guiceProbe -> guiceProbe.getClass()));
    }

    public <T extends GuiceProbe> T getProbe(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        return (T)Optional.ofNullable(this.registry.get(clazz)).map(probe -> probe).orElseThrow(() -> new RuntimeException("No probe registered for class: " + clazz));
    }
}

