/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import java.io.Serializable;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.utils.Startables;

public class StartablesModule
extends AbstractModule {
    private final Startables startables = new Startables();

    protected void configure() {
        this.bind(Startables.class).toInstance((Object)this.startables);
        this.bindListener((Matcher)new SubclassesOf(Startable.class), this::hear);
    }

    private <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        InjectionListener injectionListener = ignored -> this.startables.add(type.getRawType().asSubclass(Startable.class));
        encounter.register(injectionListener);
    }

    private static class SubclassesOf
    extends AbstractMatcher<TypeLiteral<?>>
    implements Serializable {
        private final Class<?> superclass;

        private SubclassesOf(Class<?> superclass) {
            this.superclass = (Class)Preconditions.checkNotNull(superclass, (Object)"superclass");
        }

        public boolean matches(TypeLiteral<?> type) {
            return this.superclass.isAssignableFrom(type.getRawType());
        }
    }
}

