/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class StartUpChecksPerformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartUpChecksPerformer.class);
    private final StartUpChecks startUpChecks;

    @VisibleForTesting
    static StartUpChecksPerformer from(StartUpCheck ... checks) {
        return new StartUpChecksPerformer(new StartUpChecks(Sets.newHashSet((Object[])checks)));
    }

    @Inject
    public StartUpChecksPerformer(StartUpChecks startUpChecks) {
        this.startUpChecks = startUpChecks;
    }

    public void performCheck() throws StartUpChecksException {
        List badChecks = (List)this.startUpChecks.check().stream().filter(StartUpCheck.CheckResult::isBad).collect(Guavate.toImmutableList());
        if (!badChecks.isEmpty()) {
            throw new StartUpChecksException(badChecks);
        }
        LOGGER.info("StartUpChecks all succeeded");
    }

    static class StartUpChecks {
        private final Set<StartUpCheck> startUpChecks;

        @Inject
        StartUpChecks(Set<StartUpCheck> startUpChecks) {
            this.startUpChecks = startUpChecks;
        }

        public List<StartUpCheck.CheckResult> check() {
            return (List)Flux.fromIterable(this.startUpChecks).publishOn(Schedulers.elastic()).map(this::checkQuietly).collect(Guavate.toImmutableList()).block();
        }

        private StartUpCheck.CheckResult checkQuietly(StartUpCheck startUpCheck) {
            try {
                return startUpCheck.check();
            }
            catch (Exception e) {
                LOGGER.error("Error during the {} check", (Object)startUpCheck.checkName(), (Object)e);
                return StartUpCheck.CheckResult.builder().checkName(startUpCheck.checkName()).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build();
            }
        }
    }

    public static class StartUpChecksException
    extends Exception {
        private final List<StartUpCheck.CheckResult> badChecks;

        private static String badChecksToString(List<StartUpCheck.CheckResult> badChecks) {
            Preconditions.checkArgument((!badChecks.isEmpty() ? 1 : 0) != 0, (Object)"'badChecks' should not be empty");
            Preconditions.checkArgument((boolean)badChecks.stream().noneMatch(StartUpCheck.CheckResult::isGood), (Object)"'badChecks' should not have any good check");
            return Joiner.on((String)"\n").join(badChecks);
        }

        StartUpChecksException(List<StartUpCheck.CheckResult> badChecks) {
            super("StartUpChecks got bad results: " + StartUpChecksException.badChecksToString(badChecks));
            this.badChecks = badChecks;
        }

        @VisibleForTesting
        public List<StartUpCheck.CheckResult> getBadChecks() {
            return this.badChecks;
        }

        @VisibleForTesting
        public List<String> badCheckNames() {
            return (List)this.badChecks.stream().map(StartUpCheck.CheckResult::getName).collect(Guavate.toImmutableList());
        }
    }
}

