/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.github.steveash.guavate.Guavate;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.CassandraGlobalMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerDomainMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerUserMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.Limits;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraPerUserMaxQuotaManager
implements MaxQuotaManager {
    private final CassandraPerUserMaxQuotaDao perUserQuota;
    private final CassandraPerDomainMaxQuotaDao perDomainQuota;
    private final CassandraGlobalMaxQuotaDao globalQuota;

    @Inject
    public CassandraPerUserMaxQuotaManager(CassandraPerUserMaxQuotaDao perUserQuota, CassandraPerDomainMaxQuotaDao domainQuota, CassandraGlobalMaxQuotaDao globalQuota) {
        this.perUserQuota = perUserQuota;
        this.perDomainQuota = domainQuota;
        this.globalQuota = globalQuota;
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        this.perUserQuota.setMaxStorage(quotaRoot, maxStorageQuota).block();
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.perUserQuota.setMaxMessage(quotaRoot, maxMessageCount).block();
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.perDomainQuota.setMaxMessage(domain, count).block();
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.perDomainQuota.setMaxStorage(domain, size).block();
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.perDomainQuota.removeMaxMessage(domain).block();
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.perDomainQuota.removeMaxStorage(domain).block();
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return this.perDomainQuota.getMaxMessage(domain).blockOptional();
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return this.perDomainQuota.getMaxStorage(domain).blockOptional();
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.perUserQuota.removeMaxMessage(quotaRoot).block();
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.perUserQuota.removeMaxStorage(quotaRoot).block();
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.globalQuota.setGlobalMaxStorage(globalMaxStorage).block();
    }

    public void removeGlobalMaxStorage() {
        this.globalQuota.removeGlobaltMaxStorage().block();
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.globalQuota.setGlobalMaxMessage(globalMaxMessageCount).block();
    }

    public void removeGlobalMaxMessage() {
        this.globalQuota.removeGlobalMaxMessage().block();
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.globalQuota.getGlobalMaxStorage().blockOptional();
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.globalQuota.getGlobalMaxMessage().blockOptional();
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        Publisher[] publisherArray = new Publisher[3];
        publisherArray[0] = this.perUserQuota.getMaxMessage(quotaRoot).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit));
        publisherArray[1] = Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getMaxMessage).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit));
        publisherArray[2] = this.globalQuota.getGlobalMaxMessage().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit));
        return (Map)Flux.merge((Publisher[])publisherArray).collect(Guavate.toImmutableMap(Pair::getKey, Pair::getValue)).block();
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        Publisher[] publisherArray = new Publisher[3];
        publisherArray[0] = this.perUserQuota.getMaxStorage(quotaRoot).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit));
        publisherArray[1] = Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getMaxStorage).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit));
        publisherArray[2] = this.globalQuota.getGlobalMaxStorage().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit));
        return (Map)Flux.merge((Publisher[])publisherArray).collect(Guavate.toImmutableMap(Pair::getKey, Pair::getValue)).block();
    }

    public MaxQuotaManager.QuotaDetails quotaDetails(QuotaRoot quotaRoot) {
        return (MaxQuotaManager.QuotaDetails)Mono.zip(this.perUserQuota.getLimits(quotaRoot), (Mono)Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getLimits).switchIfEmpty(Mono.just((Object)Limits.empty())), (Mono)this.globalQuota.getGlobalMaxStorage().map(Optional::of).switchIfEmpty(Mono.just(Optional.empty())), (Mono)this.globalQuota.getGlobalMaxMessage().map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()))).map(tuple -> new MaxQuotaManager.QuotaDetails(this.countDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), (Optional)tuple.getT4()), this.sizeDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), (Optional)tuple.getT3()))).block();
    }

    private Map<Quota.Scope, QuotaSizeLimit> sizeDetails(Limits userLimits, Limits domainLimits, Optional<QuotaSizeLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(Guavate.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private Map<Quota.Scope, QuotaCountLimit> countDetails(Limits userLimits, Limits domainLimits, Optional<QuotaCountLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(Guavate.toImmutableMap(Pair::getKey, Pair::getValue));
    }
}

