/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.mail.CassandraIdAndPath;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathDAOImpl;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV2DAO;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MailboxPathV2Migration
implements Migration {
    public static final Logger LOGGER = LoggerFactory.getLogger(MailboxPathV2Migration.class);
    public static final TaskType TYPE = TaskType.of((String)"cassandra-mailbox-path-v2-migration");
    private static final int CONCURRENCY = 50;
    private final CassandraMailboxPathDAOImpl daoV1;
    private final CassandraMailboxPathV2DAO daoV2;
    private final long initialCount;

    @Inject
    public MailboxPathV2Migration(CassandraMailboxPathDAOImpl daoV1, CassandraMailboxPathV2DAO daoV2) {
        this.daoV1 = daoV1;
        this.daoV2 = daoV2;
        this.initialCount = this.getCurrentCount();
    }

    public void apply() {
        this.daoV1.readAll().flatMap(this::migrate, 50).doOnError(t -> LOGGER.error("Error while performing migration", t)).blockLast();
    }

    private Mono<Void> migrate(CassandraIdAndPath idAndPath) {
        return this.daoV2.save(idAndPath.getMailboxPath(), idAndPath.getCassandraId()).then(this.daoV1.delete(idAndPath.getMailboxPath())).onErrorResume(error -> this.handleErrorMigrate(idAndPath, (Throwable)error)).then();
    }

    private Mono<Void> handleErrorMigrate(CassandraIdAndPath idAndPath, Throwable throwable) {
        LOGGER.error("Error while performing migration for path {}", (Object)idAndPath.getMailboxPath(), (Object)throwable);
        return Mono.error((Throwable)throwable);
    }

    public Task asTask() {
        return new MailboxPathV2MigrationTask(this);
    }

    AdditionalInformation getAdditionalInformation() {
        return new AdditionalInformation(this.getCurrentCount(), this.initialCount, Clock.systemUTC().instant());
    }

    private Long getCurrentCount() {
        return (Long)this.daoV1.countAll().block();
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final long remainingCount;
        private final long initialCount;
        private final Instant timestamp;

        public AdditionalInformation(long remainingCount, long initialCount, Instant timestamp) {
            this.remainingCount = remainingCount;
            this.initialCount = initialCount;
            this.timestamp = timestamp;
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    static class MailboxPathV2MigrationTask
    implements Task {
        private final MailboxPathV2Migration migration;

        MailboxPathV2MigrationTask(MailboxPathV2Migration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.getAdditionalInformation());
        }
    }
}

