/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIdTable;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMessageIdDAO {
    private static final String IMAP_UID_GTE = "uid_GTE";
    private static final String IMAP_UID_LTE = "uid_LTE";
    public static final String LIMIT = "LIMIT_BIND_MARKER";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraMessageId.Factory messageIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectAll;
    private final PreparedStatement selectAllUids;
    private final PreparedStatement selectAllLimited;
    private final PreparedStatement selectUidGte;
    private final PreparedStatement selectUidGteLimited;
    private final PreparedStatement selectUidRange;
    private final PreparedStatement selectUidRangeLimited;
    private final PreparedStatement update;
    private final PreparedStatement listStatement;

    @Inject
    public CassandraMessageIdDAO(Session session, CassandraMessageId.Factory messageIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.messageIdFactory = messageIdFactory;
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.select = this.prepareSelect(session);
        this.selectAll = this.prepareSelectAll(session);
        this.selectAllUids = this.prepareSelectAllUids(session);
        this.selectAllLimited = this.prepareSelectAllLimited(session);
        this.selectUidGte = this.prepareSelectUidGte(session);
        this.selectUidGteLimited = this.prepareSelectUidGteLimited(session);
        this.selectUidRange = this.prepareSelectUidRange(session);
        this.selectUidRangeLimited = this.prepareSelectUidRangeLimited(session);
        this.listStatement = this.prepareList(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"messageIdTable").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")).value("modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered")).value("flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted")).value("flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft")).value("flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged")).value("flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent")).value("flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen")).value("flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser")).value("userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags")));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"messageIdTable").with(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.set((String)"userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareSelectAllUids(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareSelectAllLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable"));
    }

    private PreparedStatement prepareSelectUidGte(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareSelectUidGteLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    private PreparedStatement prepareSelectUidRange(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_GTE))).and(QueryBuilder.lte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_LTE))));
    }

    private PreparedStatement prepareSelectUidRangeLimited(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMessageIdTable.FIELDS).from("messageIdTable").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_GTE))).and(QueryBuilder.lte((String)"uid", (Object)QueryBuilder.bindMarker((String)IMAP_UID_LTE))).limit(QueryBuilder.bindMarker((String)LIMIT)));
    }

    public Mono<Void> delete(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> insert(ComposedMessageIdWithMetaData composedMessageIdWithMetaData) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        Flags flags = composedMessageIdWithMetaData.getFlags();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insert.bind().setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setLong("modSeq", composedMessageIdWithMetaData.getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags())));
    }

    public Mono<Void> updateMetadata(ComposedMessageIdWithMetaData composedMessageIdWithMetaData) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        Flags flags = composedMessageIdWithMetaData.getFlags();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.update.bind().setLong("modSeq", composedMessageIdWithMetaData.getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags())).setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()));
    }

    public Mono<Optional<ComposedMessageIdWithMetaData>> retrieve(CassandraId mailboxId, MessageUid uid) {
        return this.asOptionalOfCassandraMessageId(this.selectOneRow(mailboxId, uid));
    }

    private Mono<Optional<ComposedMessageIdWithMetaData>> asOptionalOfCassandraMessageId(Mono<Row> row) {
        return row.map(this::fromRowToComposedMessageIdWithFlags).defaultIfEmpty(Optional.empty());
    }

    private Mono<Row> selectOneRow(CassandraId mailboxId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Flux<ComposedMessageIdWithMetaData> retrieveMessages(CassandraId mailboxId, MessageRange set, Limit limit) {
        return this.retrieveRows(mailboxId, set, limit).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    public Flux<MessageUid> listUids(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAllUids.bind().setUUID("mailboxId", mailboxId.asUuid())).map(row -> MessageUid.of((long)row.getLong("uid")));
    }

    public Flux<ComposedMessageIdWithMetaData> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind()).map(this::fromRowToComposedMessageIdWithFlags).handle(ReactorUtils.publishIfPresent());
    }

    private Flux<Row> retrieveRows(CassandraId mailboxId, MessageRange set, Limit limit) {
        switch (set.getType()) {
            case ALL: {
                return this.selectAll(mailboxId, limit);
            }
            case FROM: {
                return this.selectFrom(mailboxId, set.getUidFrom(), limit);
            }
            case RANGE: {
                return this.selectRange(mailboxId, set.getUidFrom(), set.getUidTo(), limit);
            }
            case ONE: {
                return Flux.concat((Publisher[])new Publisher[]{this.selectOneRow(mailboxId, set.getUidFrom())});
            }
        }
        throw new UnsupportedOperationException();
    }

    private Flux<Row> selectAll(CassandraId mailboxId, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectAllLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setInt(LIMIT, limitAsInt.intValue())).orElse(this.selectAll.bind().setUUID("mailboxId", mailboxId.asUuid())));
    }

    private Flux<Row> selectFrom(CassandraId mailboxId, MessageUid uid, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectUidGteLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong()).setInt(LIMIT, limitAsInt.intValue())).orElse(this.selectUidGte.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("uid", uid.asLong())));
    }

    private Flux<Row> selectRange(CassandraId mailboxId, MessageUid from, MessageUid to, Limit limit) {
        return this.cassandraAsyncExecutor.executeRows((Statement)limit.getLimit().map(limitAsInt -> this.selectUidRangeLimited.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong(IMAP_UID_GTE, from.asLong()).setLong(IMAP_UID_LTE, to.asLong()).setInt(LIMIT, limitAsInt.intValue())).orElse(this.selectUidRange.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong(IMAP_UID_GTE, from.asLong()).setLong(IMAP_UID_LTE, to.asLong())));
    }

    private Optional<ComposedMessageIdWithMetaData> fromRowToComposedMessageIdWithFlags(Row row) {
        if (row.getUUID("messageId") == null) {
            this.delete(CassandraId.of(row.getUUID("mailboxId")), MessageUid.of((long)row.getLong("uid"))).subscribeOn(Schedulers.elastic()).subscribe();
            return Optional.empty();
        }
        return Optional.of(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of(row.getUUID("mailboxId")), (MessageId)CassandraMessageId.Factory.of(row.getUUID("messageId")), MessageUid.of((long)row.getLong("uid")))).flags(FlagsExtractor.getFlags(row)).modSeq(ModSeq.of((long)row.getLong("modSeq"))).build());
    }
}

