/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.utils.MailboxBaseTupleUtil;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxTable;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxDAO {
    private final CassandraAsyncExecutor executor;
    private final MailboxBaseTupleUtil mailboxBaseTupleUtil;
    private final CassandraUtils cassandraUtils;
    private final PreparedStatement readStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement updateStatement;
    private final PreparedStatement updateUidValidityStatement;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraMailboxDAO(Session session, CassandraTypesProvider typesProvider, CassandraConsistenciesConfiguration consistenciesConfiguration, CassandraUtils cassandraUtils) {
        this.executor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getRegular();
        this.mailboxBaseTupleUtil = new MailboxBaseTupleUtil(typesProvider);
        this.insertStatement = this.prepareInsert(session);
        this.updateStatement = this.prepareUpdate(session);
        this.updateUidValidityStatement = this.prepareUpdateUidValidity(session);
        this.deleteStatement = this.prepareDelete(session);
        this.listStatement = this.prepareList(session);
        this.readStatement = this.prepareRead(session);
        this.cassandraUtils = cassandraUtils;
    }

    @VisibleForTesting
    public CassandraMailboxDAO(Session session, CassandraTypesProvider typesProvider, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this(session, typesProvider, consistenciesConfiguration, CassandraUtils.WITH_DEFAULT_CONFIGURATION);
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailbox").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("name", (Object)QueryBuilder.bindMarker((String)"name")).value("uidvalidity", (Object)QueryBuilder.bindMarker((String)"uidvalidity")).value("mailboxbase", (Object)QueryBuilder.bindMarker((String)"mailboxbase")));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"mailbox").with(QueryBuilder.set((String)"mailboxbase", (Object)QueryBuilder.bindMarker((String)"mailboxbase"))).and(QueryBuilder.set((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareUpdateUidValidity(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"mailbox").with(QueryBuilder.set((String)"uidvalidity", (Object)QueryBuilder.bindMarker((String)"uidvalidity"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailbox").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxTable.FIELDS).from("mailbox"));
    }

    private PreparedStatement prepareRead(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxTable.FIELDS).from("mailbox").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    public Mono<Void> save(Mailbox mailbox) {
        CassandraId cassandraId = (CassandraId)mailbox.getMailboxId();
        return this.executor.executeVoid((Statement)this.insertStatement.bind().setUUID("id", cassandraId.asUuid()).setString("name", mailbox.getName()).setLong("uidvalidity", mailbox.getUidValidity().asLong()).setUDTValue("mailboxbase", this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailbox.getNamespace(), mailbox.getUser())));
    }

    public Mono<Void> updatePath(CassandraId mailboxId, MailboxPath mailboxPath) {
        return this.executor.executeVoid((Statement)this.updateStatement.bind().setUUID("id", mailboxId.asUuid()).setString("name", mailboxPath.getName()).setUDTValue("mailboxbase", this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailboxPath.getNamespace(), mailboxPath.getUser())));
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind().setUUID("id", mailboxId.asUuid()));
    }

    public Mono<Mailbox> retrieveMailbox(CassandraId mailboxId) {
        return this.executor.executeSingleRow(this.readStatement.bind().setUUID("id", mailboxId.asUuid()).setConsistencyLevel(this.consistencyLevel)).flatMap(row -> this.mailboxFromRow((Row)row, mailboxId));
    }

    private Mono<Mailbox> mailboxFromRow(Row row, CassandraId cassandraId) {
        return this.sanitizeUidValidity(cassandraId, row.getLong("uidvalidity")).map(uidValidity -> new Mailbox(new MailboxPath(row.getUDTValue("mailboxbase").getString("namespace"), Username.of((String)row.getUDTValue("mailboxbase").getString("user")), row.getString("name")), uidValidity, (MailboxId)cassandraId));
    }

    private Mono<UidValidity> sanitizeUidValidity(CassandraId cassandraId, long uidValidityAsLong) {
        if (!UidValidity.isValid((long)uidValidityAsLong)) {
            UidValidity newUidValidity = UidValidity.generate();
            return this.updateUidValidity(cassandraId, newUidValidity).then(Mono.just((Object)newUidValidity));
        }
        return Mono.just((Object)UidValidity.of((long)uidValidityAsLong));
    }

    private Mono<Void> updateUidValidity(CassandraId cassandraId, UidValidity uidValidity) {
        return this.executor.executeVoid((Statement)this.updateUidValidityStatement.bind().setUUID("id", cassandraId.asUuid()).setLong("uidvalidity", uidValidity.asLong()));
    }

    public Flux<Mailbox> retrieveAllMailboxes() {
        return this.executor.execute((Statement)this.listStatement.bind()).flatMapMany(arg_0 -> ((CassandraUtils)this.cassandraUtils).convertToFlux(arg_0)).flatMap(this::toMailboxWithId, 16);
    }

    private Mono<Mailbox> toMailboxWithId(Row row) {
        return this.mailboxFromRow(row, CassandraId.of(row.getUUID("id")));
    }
}

