/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import reactor.core.publisher.Mono;

public class CassandraMailboxCounterDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final PreparedStatement incrementUnseenCountStatement;
    private final PreparedStatement incrementMessageCountStatement;
    private final PreparedStatement addToCounters;
    private final PreparedStatement removeToCounters;
    private final PreparedStatement decrementUnseenCountStatement;
    private final PreparedStatement decrementMessageCountStatement;
    private final PreparedStatement incrementUnseenAndCountStatement;
    private final PreparedStatement decrementUnseenAndCountStatement;
    private final PreparedStatement deleteStatement;

    @Inject
    public CassandraMailboxCounterDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = this.createReadStatement(session);
        this.incrementMessageCountStatement = this.updateMailboxStatement(session, QueryBuilder.incr((String)"count"));
        this.incrementUnseenCountStatement = this.updateMailboxStatement(session, QueryBuilder.incr((String)"unseen"));
        this.addToCounters = session.prepare((RegularStatement)QueryBuilder.update((String)"mailboxCounters").with(QueryBuilder.incr((String)"count", (BindMarker)QueryBuilder.bindMarker((String)"count"))).and(QueryBuilder.incr((String)"unseen", (BindMarker)QueryBuilder.bindMarker((String)"unseen"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.removeToCounters = session.prepare((RegularStatement)QueryBuilder.update((String)"mailboxCounters").with(QueryBuilder.decr((String)"count", (BindMarker)QueryBuilder.bindMarker((String)"count"))).and(QueryBuilder.decr((String)"unseen", (BindMarker)QueryBuilder.bindMarker((String)"unseen"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.decrementMessageCountStatement = this.updateMailboxStatement(session, QueryBuilder.decr((String)"count"));
        this.decrementUnseenCountStatement = this.updateMailboxStatement(session, QueryBuilder.decr((String)"unseen"));
        this.incrementUnseenAndCountStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"mailboxCounters").with(QueryBuilder.incr((String)"count")).and(QueryBuilder.incr((String)"unseen")).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.decrementUnseenAndCountStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"mailboxCounters").with(QueryBuilder.decr((String)"count")).and(QueryBuilder.decr((String)"unseen")).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
        this.deleteStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxCounters").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement createReadStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"unseen", "count"}).from("mailboxCounters").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement updateMailboxStatement(Session session, Assignment operation) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"mailboxCounters").with(operation).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.deleteStatement));
    }

    public Mono<MailboxCounters> retrieveMailboxCounters(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count(row.getLong("count")).unseen(row.getLong("unseen")).build());
    }

    public Mono<Void> resetCounters(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.retrieveMailboxCounters(mailboxId).defaultIfEmpty((Object)this.emptyCounters(mailboxId)).flatMap(storedCounters -> {
            if (storedCounters.equals((Object)counters)) {
                return Mono.empty();
            }
            return this.remove((MailboxCounters)storedCounters).then(this.add(counters));
        });
    }

    private MailboxCounters emptyCounters(CassandraId mailboxId) {
        return MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count(0L).unseen(0L).build();
    }

    public Mono<Void> add(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.addToCounters).setLong("count", counters.getCount()).setLong("unseen", counters.getUnseen()));
    }

    public Mono<Void> remove(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.removeToCounters).setLong("count", counters.getCount()).setLong("unseen", counters.getUnseen()));
    }

    public Mono<Long> countMessagesInMailbox(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.countMessagesInMailbox(mailboxId);
    }

    public Mono<Long> countMessagesInMailbox(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(cassandraId, this.readStatement)).map(row -> row.getLong("count"));
    }

    public Mono<Long> countUnseenMessagesInMailbox(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> row.getLong("unseen"));
    }

    public Mono<Void> decrementCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementMessageCountStatement));
    }

    public Mono<Void> incrementCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementMessageCountStatement));
    }

    public Mono<Void> decrementUnseen(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementUnseenCountStatement));
    }

    public Mono<Void> incrementUnseen(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementUnseenCountStatement));
    }

    public Mono<Void> decrementUnseenAndCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementUnseenAndCountStatement));
    }

    public Mono<Void> incrementUnseenAndCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementUnseenAndCountStatement));
    }

    public Mono<Void> incrementUnseenAndCount(CassandraId mailboxId, long count, long unseen) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.addToCounters).setLong("count", count).setLong("unseen", unseen));
    }

    private BoundStatement bindWithMailbox(CassandraId mailboxId, PreparedStatement statement) {
        return statement.bind().setUUID("mailboxId", mailboxId.asUuid());
    }
}

