/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class KeyspaceConfiguration {
    private static final String DEFAULT_KEYSPACE = "apache_james";
    private static final int DEFAULT_REPLICATION_FACTOR = 1;
    private static final boolean DEFAULT_SSL = false;
    private final String keyspace;
    private final int replicationFactor;
    private final boolean durableWrites;

    public static Builder.RequireKeyspace builder() {
        return name -> replicationFactor -> durableWrites -> new KeyspaceConfiguration(name, replicationFactor, durableWrites);
    }

    public KeyspaceConfiguration(String keyspace, int replicationFactor, boolean durableWrites) {
        Preconditions.checkArgument((replicationFactor > 0 ? 1 : 0) != 0, (Object)"'' needs to be strictly positive");
        this.keyspace = keyspace;
        this.replicationFactor = replicationFactor;
        this.durableWrites = durableWrites;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public final boolean equals(Object o) {
        if (o instanceof KeyspaceConfiguration) {
            KeyspaceConfiguration that = (KeyspaceConfiguration)o;
            return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.replicationFactor, that.replicationFactor) && Objects.equals(this.durableWrites, that.durableWrites);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.keyspace, this.replicationFactor, this.durableWrites);
    }

    public static interface Builder {

        @FunctionalInterface
        public static interface RequireDurableWrites {
            public KeyspaceConfiguration durableWrites(boolean var1);

            default public KeyspaceConfiguration disableDurableWrites() {
                return this.durableWrites(false);
            }
        }

        @FunctionalInterface
        public static interface RequireReplicationFactor {
            public RequireDurableWrites replicationFactor(int var1);
        }

        @FunctionalInterface
        public static interface RequireKeyspace {
            public RequireReplicationFactor keyspace(String var1);
        }
    }
}

