/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import reactor.core.publisher.Mono;

public class CassandraDefaultBucketDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertPart;
    private final PreparedStatement select;
    private final PreparedStatement selectPart;
    private final PreparedStatement delete;
    private final PreparedStatement deleteParts;

    @Inject
    @VisibleForTesting
    public CassandraDefaultBucketDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.select = this.prepareSelect(session);
        this.insertPart = this.prepareInsertPart(session);
        this.selectPart = this.prepareSelectPart(session);
        this.delete = this.prepareDelete(session);
        this.deleteParts = this.prepareDeleteParts(session);
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blobs").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareSelectPart(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("blobParts").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).and(QueryBuilder.eq((String)"chunkNumber", (Object)QueryBuilder.bindMarker((String)"chunkNumber"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"blobs").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("position", (Object)QueryBuilder.bindMarker((String)"position")));
    }

    private PreparedStatement prepareInsertPart(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"blobParts").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("chunkNumber", (Object)QueryBuilder.bindMarker((String)"chunkNumber")).value("data", (Object)QueryBuilder.bindMarker((String)"data")));
    }

    private PreparedStatement prepareDeleteParts(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("blobParts").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("blobs").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    Mono<Void> writePart(ByteBuffer data, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertPart.bind().setString("id", blobId.asString()).setInt("chunkNumber", position).setBytes("data", data));
    }

    Mono<Void> saveBlobPartsReferences(BlobId blobId, int numberOfChunk) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insert.bind().setString("id", blobId.asString()).setInt("position", numberOfChunk));
    }

    Mono<Integer> selectRowCount(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind().setString("id", blobId.asString())).map(row -> row.getInt("position"));
    }

    Mono<ByteBuffer> readPart(BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectPart.bind().setString("id", blobId.asString()).setInt("chunkNumber", position)).map(this::rowToData);
    }

    Mono<Void> deletePosition(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setString("id", blobId.asString()));
    }

    Mono<Void> deleteParts(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteParts.bind().setString("id", blobId.asString()));
    }

    private ByteBuffer rowToData(Row row) {
        return row.getBytes("data");
    }
}

