/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.driver.core.Session;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;

public class CassandraBlobStoreFactory {
    public static BlobStoreFactory.RequireStoringStrategy forTesting(Session session) {
        HashBlobId.Factory blobIdFactory = new HashBlobId.Factory();
        CassandraBucketDAO bucketDAO = new CassandraBucketDAO((BlobId.Factory)blobIdFactory, session);
        CassandraDefaultBucketDAO defaultBucketDAO = new CassandraDefaultBucketDAO(session);
        CassandraBlobStoreDAO blobStoreDAO = new CassandraBlobStoreDAO(defaultBucketDAO, bucketDAO, CassandraConfiguration.DEFAULT_CONFIGURATION, BucketName.DEFAULT);
        return BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)blobStoreDAO).blobIdFactory((BlobId.Factory)blobIdFactory).defaultBucketName();
    }
}

