/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class MessageFastViewProjectionCorrector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFastViewProjectionCorrector.class);
    private static final Duration PERIOD = Duration.ofSeconds(1L);
    public static final int USER_CONCURRENCY = 1;
    public static final int MAILBOX_CONCURRENCY = 1;
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final MessageFastViewProjection messageFastViewProjection;
    private final MessageFastViewPrecomputedProperties.Factory projectionItemFactory;

    @Inject
    MessageFastViewProjectionCorrector(UsersRepository usersRepository, MailboxManager mailboxManager, MessageFastViewProjection messageFastViewProjection, MessageFastViewPrecomputedProperties.Factory projectionItemFactory) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
        this.messageFastViewProjection = messageFastViewProjection;
        this.projectionItemFactory = projectionItemFactory;
    }

    Mono<Task.Result> correctAllProjectionItems(Progress progress, RunningOptions runningOptions) {
        return this.correctProjection(this.listAllMailboxMessages(progress), runningOptions, progress);
    }

    Mono<Task.Result> correctUsersProjectionItems(Progress progress, Username username, RunningOptions runningOptions) {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        return this.correctProjection(this.listUserMailboxMessages(progress, session), runningOptions, progress);
    }

    private Flux<ProjectionEntry> listAllMailboxMessages(Progress progress) {
        try {
            return Iterators.toFlux((Iterator)this.usersRepository.list()).map(arg_0 -> ((MailboxManager)this.mailboxManager).createSystemSession(arg_0)).doOnNext(any -> progress.incrementProcessedUserCount()).flatMap(session -> this.listUserMailboxMessages(progress, (MailboxSession)session), 1);
        }
        catch (UsersRepositoryException e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ProjectionEntry> listUserMailboxMessages(Progress progress, MailboxSession session) {
        return this.listUsersMailboxes(session).flatMap(mailboxMetadata -> this.retrieveMailbox(session, (MailboxMetaData)mailboxMetadata), 1).flatMap((Function)Throwing.function(messageManager -> this.listAllMailboxMessages((MessageManager)messageManager, session).map(message -> new ProjectionEntry((MessageManager)messageManager, message.getComposedMessageId().getUid(), session))), 1).onErrorResume(MailboxException.class, e -> {
            LOGGER.error("JMAP fastview re-computation aborted for {} as we failed listing user mailboxes", (Object)session.getUser(), e);
            progress.incrementFailedUserCount();
            return Flux.empty();
        });
    }

    private Mono<Task.Result> correctProjection(ProjectionEntry entry, Progress progress) {
        return this.retrieveContent(entry.getMessageManager(), entry.getSession(), entry.getUid()).map(this::computeProjectionEntry).flatMap(this::storeProjectionEntry).doOnSuccess(any -> progress.incrementProcessedMessageCount()).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("JMAP fastview re-computation aborted for {} - {} - {}", new Object[]{entry.getSession().getUser(), entry.getMessageManager().getId(), entry.getUid(), e});
            progress.incrementFailedMessageCount();
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Mono<Task.Result> correctProjection(Flux<ProjectionEntry> entries, RunningOptions runningOptions, Progress progress) {
        return entries.transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(entry -> this.correctProjection((ProjectionEntry)entry, progress))).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED));
    }

    private Flux<MailboxMetaData> listUsersMailboxes(MailboxSession session) {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), MailboxManager.MailboxSearchFetchType.Minimal, session);
    }

    private Mono<MessageManager> retrieveMailbox(MailboxSession session, MailboxMetaData mailboxMetadata) {
        return Mono.fromCallable(() -> this.mailboxManager.getMailbox(mailboxMetadata.getId(), session)).subscribeOn(Schedulers.elastic());
    }

    private Flux<ComposedMessageIdWithMetaData> listAllMailboxMessages(MessageManager messageManager, MailboxSession session) {
        return Flux.from((Publisher)messageManager.listMessagesMetadata(MessageRange.all(), session));
    }

    private Mono<MessageResult> retrieveContent(MessageManager messageManager, MailboxSession session, MessageUid uid) {
        try {
            return Iterators.toFlux((Iterator)messageManager.getMessages(MessageRange.one((MessageUid)uid), FetchGroup.FULL_CONTENT, session)).subscribeOn(Schedulers.elastic()).next();
        }
        catch (MailboxException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Pair<MessageId, MessageFastViewPrecomputedProperties> computeProjectionEntry(MessageResult messageResult) {
        try {
            return Pair.of((Object)messageResult.getMessageId(), (Object)this.projectionItemFactory.from(messageResult));
        }
        catch (IOException | MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private Mono<Void> storeProjectionEntry(Pair<MessageId, MessageFastViewPrecomputedProperties> pair) {
        return Mono.from((Publisher)this.messageFastViewProjection.store((MessageId)pair.getKey(), (MessageFastViewPrecomputedProperties)pair.getValue()));
    }

    static class Progress {
        private final AtomicLong processedUserCount;
        private final AtomicLong processedMessageCount;
        private final AtomicLong failedUserCount = new AtomicLong();
        private final AtomicLong failedMessageCount;

        Progress() {
            this.processedMessageCount = new AtomicLong();
            this.processedUserCount = new AtomicLong();
            this.failedMessageCount = new AtomicLong();
        }

        private void incrementProcessedUserCount() {
            this.processedUserCount.incrementAndGet();
        }

        private void incrementProcessedMessageCount() {
            this.processedMessageCount.incrementAndGet();
        }

        private void incrementFailedUserCount() {
            this.failedUserCount.incrementAndGet();
        }

        private void incrementFailedMessageCount() {
            this.failedMessageCount.incrementAndGet();
        }

        long getProcessedUserCount() {
            return this.processedUserCount.get();
        }

        long getProcessedMessageCount() {
            return this.processedMessageCount.get();
        }

        long getFailedUserCount() {
            return this.failedUserCount.get();
        }

        long getFailedMessageCount() {
            return this.failedMessageCount.get();
        }
    }

    private static class ProjectionEntry {
        private final MessageManager messageManager;
        private final MessageUid uid;
        private final MailboxSession session;

        private ProjectionEntry(MessageManager messageManager, MessageUid uid, MailboxSession session) {
            this.messageManager = messageManager;
            this.uid = uid;
            this.session = session;
        }

        private MessageManager getMessageManager() {
            return this.messageManager;
        }

        private MessageUid getUid() {
            return this.uid;
        }

        private MailboxSession getSession() {
            return this.session;
        }
    }
}

