/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.camel.Body;
import org.apache.camel.Handler;
import org.apache.camel.InOnly;
import org.apache.james.core.MailAddress;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.MDCBuilder;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InOnly
public class MatcherSplitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatcherSplitter.class);
    public static final AttributeName MATCHER_MATCHED_ATTRIBUTE = AttributeName.of((String)"matched");
    private final MetricFactory metricFactory;
    private final CamelMailetProcessor container;
    private final Matcher matcher;
    private final String onMatchException;

    public MatcherSplitter(MetricFactory metricFactory, CamelMailetProcessor container, MatcherMailetPair pair) {
        this.metricFactory = metricFactory;
        this.container = container;
        this.matcher = pair.getMatcher();
        this.onMatchException = Optional.ofNullable(pair.getOnMatchException()).map(s -> s.trim().toLowerCase(Locale.US)).orElse("error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    public List<Mail> split(@Body Mail mail) throws MessagingException {
        Collection<MailAddress> matchedRcpts = null;
        ArrayList<MailAddress> origRcpts = new ArrayList<MailAddress>(mail.getRecipients());
        long start = System.currentTimeMillis();
        Throwable ex = null;
        TimeMetric timeMetric = this.metricFactory.timer(this.matcher.getClass().getSimpleName());
        try {
            ArrayList<Mail> mails = new ArrayList<Mail>();
            boolean fullMatch = false;
            try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"MAILET").addContext("action", (Object)"MATCHER").addContext("ip", (Object)mail.getRemoteAddr()).addContext("host", (Object)mail.getRemoteHost()).addContext("matcher", (Object)this.matcher.getMatcherInfo()).addContext("state", (Object)mail.getState()).addContext("mail", (Object)mail.getName()).addContext("recipients", (Object)ImmutableList.copyOf((Collection)mail.getRecipients())).addContext("sender", (Object)mail.getMaybeSender()).build();){
                matchedRcpts = this.matcher.match(mail);
                if (matchedRcpts == null) {
                    matchedRcpts = new ArrayList(0);
                } else if (matchedRcpts != mail.getRecipients()) {
                    ProcessorUtil.verifyMailAddresses(matchedRcpts);
                }
            }
            catch (Exception | NoClassDefFoundError me) {
                ex = me;
                if (this.onMatchException.equalsIgnoreCase("nomatch")) {
                    LOGGER.warn("Encountered error while executing matcher {}. Matching none.", (Object)this.matcher, (Object)ex);
                    matchedRcpts = new ArrayList(0);
                }
                if (this.onMatchException.equalsIgnoreCase("matchall")) {
                    LOGGER.warn("Encountered error while executing matcher {}. matching all.", (Object)this.matcher, (Object)ex);
                    matchedRcpts = mail.getRecipients();
                }
                ProcessorUtil.handleException(me, mail, this.matcher.getMatcherConfig().getMatcherName(), this.onMatchException, LOGGER);
            }
            if (matchedRcpts != null && !matchedRcpts.isEmpty()) {
                ArrayList rcpts = new ArrayList(mail.getRecipients());
                for (MailAddress matchedRcpt : matchedRcpts) {
                    rcpts.remove(matchedRcpt);
                }
                if (rcpts.isEmpty()) {
                    fullMatch = true;
                } else {
                    mail.setRecipients(rcpts);
                    MailImpl newMail = MailImpl.duplicate((Mail)mail);
                    newMail.setRecipients(matchedRcpts);
                    newMail.setAttribute(new Attribute(MATCHER_MATCHED_ATTRIBUTE, AttributeValue.of((Boolean)true)));
                    mails.add((Mail)newMail);
                }
            }
            if (fullMatch) {
                mail.setAttribute(new Attribute(MATCHER_MATCHED_ATTRIBUTE, AttributeValue.of((Boolean)true)));
            }
            mails.add(mail);
            ArrayList<Mail> arrayList = mails;
            return arrayList;
        }
        finally {
            timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD);
            long complete = System.currentTimeMillis() - start;
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = this.container.getListeners();
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : listeners) {
                if (matchedRcpts == null || matchedRcpts.isEmpty()) {
                    listener.afterMatcher(this.matcher, mail.getName(), origRcpts, null, complete, ex);
                    continue;
                }
                listener.afterMatcher(this.matcher, mail.getName(), origRcpts, matchedRcpts, complete, ex);
            }
        }
    }
}

