/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.util.MDCBuilder;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.MailetPipelineLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelProcessor.class);
    private final MetricFactory metricFactory;
    private final Mailet mailet;
    private final CamelMailetProcessor processor;

    public CamelProcessor(MetricFactory metricFactory, CamelMailetProcessor processor, Mailet mailet) {
        this.metricFactory = metricFactory;
        this.processor = processor;
        this.mailet = mailet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Mail mail) throws Exception {
        long start = System.currentTimeMillis();
        TimeMetric timeMetric = this.metricFactory.timer(this.mailet.getClass().getSimpleName());
        Throwable ex = null;
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"MAILET").addContext("action", (Object)"MAILET").addContext("host", (Object)mail.getRemoteHost()).addContext("state", (Object)mail.getState()).addContext("mailet", (Object)this.mailet.getClass().getSimpleName()).addContext("mail", (Object)mail.getName()).addContext("recipients", (Object)ImmutableList.copyOf((Collection)mail.getRecipients())).addContext("sender", (Object)mail.getMaybeSender()).build();){
            MailetPipelineLogging.logBeginOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            this.mailet.service(mail);
        }
        catch (Exception | NoClassDefFoundError me) {
            ex = me;
            String onMailetException = null;
            MailetConfig mailetConfig = this.mailet.getMailetConfig();
            if (mailetConfig instanceof MailetConfigImpl) {
                onMailetException = mailetConfig.getInitParameter("onMailetException");
            }
            if ((onMailetException = onMailetException == null ? "error" : onMailetException.trim().toLowerCase(Locale.US)).equalsIgnoreCase("ignore")) {
                LOGGER.warn("Encountered error while executing mailet {}. Ignoring it.", (Object)this.mailet, (Object)ex);
                ProcessorUtil.verifyMailAddresses(mail.getRecipients());
            }
            ProcessorUtil.handleException(me, mail, this.mailet.getMailetConfig().getMailetName(), onMailetException, LOGGER);
        }
        finally {
            timeMetric.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD);
            MailetPipelineLogging.logEndOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = this.processor.getListeners();
            long complete = System.currentTimeMillis() - start;
            if (mail.getRecipients().isEmpty()) {
                mail.setState("ghost");
            }
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : listeners) {
                listener.afterMailet(this.mailet, mail.getName(), mail.getState(), complete, ex);
            }
        }
    }
}

