/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTaskDTO;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;

public class ErrorRecoveryIndexationTask
implements Task {
    public static final TaskType PREVIOUS_FAILURES_INDEXING = TaskType.of((String)"error-recovery-indexation");
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReprocessingContext reprocessingContext;
    private final ReIndexingExecutionFailures previousFailures;
    private final ReIndexer.RunningOptions runningOptions;

    public ErrorRecoveryIndexationTask(ReIndexerPerformer reIndexerPerformer, ReIndexingExecutionFailures previousFailures, ReIndexer.RunningOptions runningOptions) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.previousFailures = previousFailures;
        this.reprocessingContext = new ReprocessingContext();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexErrors(this.reprocessingContext, this.previousFailures, this.runningOptions).block();
    }

    public TaskType type() {
        return PREVIOUS_FAILURES_INDEXING;
    }

    public ReIndexingExecutionFailures getPreviousFailures() {
        return this.previousFailures;
    }

    public ReIndexer.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new ReprocessingContextInformationDTO.ReprocessingContextInformationForErrorRecoveryIndexationTask(this.reprocessingContext.successfullyReprocessedMailCount(), this.reprocessingContext.failedReprocessingMailCount(), this.reprocessingContext.failures(), Clock.systemUTC().instant(), this.runningOptions));
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        private List<ReIndexingExecutionFailures.ReIndexingFailure> messageFailuresFromDTO(List<ErrorRecoveryIndexationTaskDTO.ReindexingFailureDTO> messageFailures) {
            return (List)messageFailures.stream().flatMap(dto -> dto.getUids().stream().map(uid -> new ReIndexingExecutionFailures.ReIndexingFailure(this.mailboxIdFactory.fromString(dto.getMailboxId()), MessageUid.of((long)uid)))).collect(Guavate.toImmutableList());
        }

        private List<MailboxId> mailboxFailuresFromDTO(Optional<List<String>> mailboxFailures) {
            return (List)mailboxFailures.map(mailboxIdList -> (ImmutableList)mailboxIdList.stream().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableList())).orElse(ImmutableList.of());
        }

        public ErrorRecoveryIndexationTask create(ErrorRecoveryIndexationTaskDTO dto) {
            return new ErrorRecoveryIndexationTask(this.reIndexerPerformer, new ReIndexingExecutionFailures(this.messageFailuresFromDTO(dto.getPreviousMessageFailures()), this.mailboxFailuresFromDTO(dto.getPreviousMailboxFailures())), dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT));
        }
    }
}

