/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.ContentBodyElement;
import org.apache.james.imap.processor.fetch.EmptyContent;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.HeaderBodyElement;
import org.apache.james.imap.processor.fetch.HeadersBodyElement;
import org.apache.james.imap.processor.fetch.MessageResultUtils;
import org.apache.james.imap.processor.fetch.MimeBodyElement;
import org.apache.james.imap.processor.fetch.MimeDescriptorStructure;
import org.apache.james.imap.processor.fetch.PartialFetchBodyElement;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimePath;

public final class FetchResponseBuilder {
    private final EnvelopeBuilder envelopeBuilder;
    private MessageSequenceNumber msn;
    private MessageUid uid;
    private Flags flags;
    private Date internalDate;
    private Long size;
    private ModSeq modSeq;
    private List<FetchResponse.BodyElement> elements;
    private FetchResponse.Envelope envelope;
    private FetchResponse.Structure body;
    private FetchResponse.Structure bodystructure;

    public FetchResponseBuilder(EnvelopeBuilder envelopeBuilder) {
        this.envelopeBuilder = envelopeBuilder;
    }

    public void reset(MessageSequenceNumber msn) {
        this.msn = msn;
        this.uid = null;
        this.flags = null;
        this.internalDate = null;
        this.size = null;
        this.body = null;
        this.bodystructure = null;
        this.elements = null;
        this.modSeq = null;
    }

    public void setUid(MessageUid resultUid) {
        this.uid = resultUid;
    }

    private void setModSeq(ModSeq modSeq) {
        this.modSeq = modSeq;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public FetchResponse build() {
        return new FetchResponse(this.msn, this.flags, this.uid, this.modSeq, this.internalDate, this.size, this.envelope, this.body, this.bodystructure, this.elements);
    }

    public FetchResponse build(FetchData fetch, MessageResult result, MessageManager mailbox, SelectedMailbox selectedMailbox, MailboxSession mailboxSession) throws MessageRangeException, MailboxException {
        MessageUid resultUid = result.getUid();
        return selectedMailbox.msn(resultUid).fold(() -> {
            throw new MessageRangeException("No such message found with uid " + resultUid);
        }, msn -> {
            this.reset(msn);
            this.addFlags(fetch, mailbox, selectedMailbox, resultUid, mailboxSession, result.getFlags());
            if (fetch.contains(FetchData.Item.INTERNAL_DATE)) {
                this.setInternalDate(result.getInternalDate());
            }
            if (fetch.contains(FetchData.Item.SIZE)) {
                this.setSize(result.getSize());
            }
            if (fetch.contains(FetchData.Item.ENVELOPE)) {
                this.envelope = this.buildEnvelope(result);
            }
            Collection<BodyFetchElement> elements = fetch.getBodyElements();
            this.elements = new ArrayList<FetchResponse.BodyElement>();
            for (BodyFetchElement fetchElement : elements) {
                FetchResponse.BodyElement element = this.bodyFetch(result, fetchElement);
                if (element == null) continue;
                this.elements.add(element);
            }
            if (fetch.contains(FetchData.Item.BODY) || fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
                if (fetch.contains(FetchData.Item.BODY) && this.elements.isEmpty()) {
                    this.body = new MimeDescriptorStructure(false, result.getMimeDescriptor(), this.envelopeBuilder);
                }
                if (fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
                    this.bodystructure = new MimeDescriptorStructure(true, result.getMimeDescriptor(), this.envelopeBuilder);
                }
            }
            this.addUid(fetch, resultUid);
            this.addModSeq(fetch, result.getModSeq());
            return this.build();
        });
    }

    private void addUid(FetchData fetch, MessageUid resultUid) {
        if (fetch.contains(FetchData.Item.UID)) {
            this.setUid(resultUid);
        }
    }

    private void addModSeq(FetchData fetch, ModSeq modSeq) {
        if (fetch.contains(FetchData.Item.MODSEQ)) {
            long changedSince = fetch.getChangedSince();
            if (changedSince != -1L) {
                if (changedSince < modSeq.asLong()) {
                    this.setModSeq(modSeq);
                }
            } else {
                this.setModSeq(modSeq);
            }
        }
    }

    private void addFlags(FetchData fetch, MessageManager mailbox, SelectedMailbox selected, MessageUid resultUid, MailboxSession mailboxSession, Flags flags) throws MailboxException {
        boolean ensureFlagsResponse = false;
        Flags resultFlags = flags;
        if (fetch.isSetSeen() && !resultFlags.contains(Flags.Flag.SEEN)) {
            mailbox.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, MessageRange.one((MessageUid)resultUid), mailboxSession);
            resultFlags.add(Flags.Flag.SEEN);
            ensureFlagsResponse = true;
        }
        if (fetch.contains(FetchData.Item.FLAGS) || ensureFlagsResponse) {
            if (selected.isRecent(resultUid)) {
                resultFlags.add(Flags.Flag.RECENT);
            }
            this.setFlags(resultFlags);
        }
    }

    public FetchResponse build(FetchData fetch, ComposedMessageIdWithMetaData result, MessageManager mailbox, SelectedMailbox selectedMailbox, MailboxSession mailboxSession) throws MessageRangeException, MailboxException {
        MessageUid resultUid = result.getComposedMessageId().getUid();
        return selectedMailbox.msn(resultUid).fold(() -> {
            throw new MessageRangeException("No such message found with uid " + resultUid);
        }, msn -> {
            this.reset(msn);
            this.addFlags(fetch, mailbox, selectedMailbox, resultUid, mailboxSession, result.getFlags());
            this.addUid(fetch, resultUid);
            this.addModSeq(fetch, result.getModSeq());
            return this.build();
        });
    }

    private FetchResponse.Envelope buildEnvelope(MessageResult result) throws MailboxException {
        return this.envelopeBuilder.buildEnvelope(result.getHeaders());
    }

    private void setSize(long size) {
        this.size = size;
    }

    public void setInternalDate(Date internalDate) {
        this.internalDate = internalDate;
    }

    private FetchResponse.BodyElement bodyFetch(MessageResult messageResult, BodyFetchElement fetchElement) throws MailboxException {
        Long firstOctet = fetchElement.getFirstOctet();
        Long numberOfOctets = fetchElement.getNumberOfOctets();
        String name = fetchElement.getResponseName();
        SectionType specifier = fetchElement.getSectionType();
        Optional<MimePath> path = Optional.ofNullable(fetchElement.getPath()).filter(paths -> ((int[])paths).length > 0).map(MimePath::new);
        Collection<String> names = fetchElement.getFieldNames();
        FetchResponse.BodyElement fullResult = this.bodyContent(messageResult, name, specifier, path, names);
        return this.wrapIfPartialFetch(firstOctet, numberOfOctets, fullResult);
    }

    private FetchResponse.BodyElement bodyContent(MessageResult messageResult, String name, SectionType specifier, Optional<MimePath> path, Collection<String> names) throws MailboxException {
        switch (specifier) {
            case CONTENT: {
                return this.content(messageResult, name, path);
            }
            case HEADER_FIELDS: {
                return this.fields(messageResult, name, path, names);
            }
            case HEADER_NOT_FIELDS: {
                return this.fieldsNot(messageResult, name, path, names);
            }
            case MIME: {
                return this.mimeHeaders(messageResult, name, path);
            }
            case HEADER: {
                return this.headers(messageResult, name, path);
            }
            case TEXT: {
                return this.text(messageResult, name, path);
            }
        }
        return null;
    }

    private FetchResponse.BodyElement wrapIfPartialFetch(Long firstOctet, Long numberOfOctets, FetchResponse.BodyElement fullResult) {
        if (firstOctet == null) {
            return fullResult;
        }
        long numberOfOctetsAsLong = Objects.requireNonNullElse(numberOfOctets, Long.MAX_VALUE);
        long firstOctetAsLong = firstOctet;
        return new PartialFetchBodyElement(fullResult, firstOctetAsLong, numberOfOctetsAsLong);
    }

    private FetchResponse.BodyElement text(MessageResult messageResult, String name, Optional<MimePath> path) throws MailboxException {
        Content body = Optional.ofNullable(this.getTextContent(messageResult, path)).orElseGet(EmptyContent::new);
        return new ContentBodyElement(name, body);
    }

    private Content getTextContent(MessageResult messageResult, Optional<MimePath> path) throws MailboxException {
        if (path.isEmpty()) {
            try {
                return messageResult.getBody();
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get TEXT of body", (Throwable)e);
            }
        }
        return messageResult.getBody(path.get());
    }

    private FetchResponse.BodyElement mimeHeaders(MessageResult messageResult, String name, Optional<MimePath> path) throws MailboxException {
        Iterator<Header> headers = this.getMimeHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getAll(headers);
        return new MimeBodyElement(name, lines);
    }

    private HeaderBodyElement headerBodyElement(MessageResult messageResult, String name, List<Header> lines, Optional<MimePath> path) throws MailboxException {
        HeaderBodyElement result = new HeaderBodyElement(name, lines);
        if (result.size() == 2L) {
            if (path.isEmpty()) {
                if (messageResult.getSize() - result.size() <= 0L) {
                    result.noBody();
                }
            } else {
                try {
                    if (this.content(messageResult, name, path).size() <= 0L) {
                        result.noBody();
                    }
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to get size of header body element", (Throwable)e);
                }
            }
        }
        return result;
    }

    private FetchResponse.BodyElement headers(MessageResult messageResult, String name, Optional<MimePath> path) throws MailboxException {
        if (path.isEmpty()) {
            HeadersBodyElement element = new HeadersBodyElement(name, (Content)messageResult.getHeaders());
            try {
                if (messageResult.getSize() - element.size() <= 0L) {
                    element.noBody();
                }
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get size of header body element", (Throwable)e);
            }
            return element;
        }
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getAll(headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private FetchResponse.BodyElement fieldsNot(MessageResult messageResult, String name, Optional<MimePath> path, Collection<String> names) throws MailboxException {
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getNotMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private FetchResponse.BodyElement fields(MessageResult messageResult, String name, Optional<MimePath> path, Collection<String> names) throws MailboxException {
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private Iterator<Header> getHeaders(MessageResult messageResult, Optional<MimePath> path) throws MailboxException {
        if (path.isEmpty()) {
            return messageResult.getHeaders().headers();
        }
        return messageResult.iterateHeaders(path.get());
    }

    private Iterator<Header> getMimeHeaders(MessageResult messageResult, Optional<MimePath> path) throws MailboxException {
        return messageResult.iterateMimeHeaders(path.get());
    }

    private FetchResponse.BodyElement content(MessageResult messageResult, String name, Optional<MimePath> path) throws MailboxException {
        Content full = Optional.ofNullable(this.getContent(messageResult, path)).orElseGet(EmptyContent::new);
        return new ContentBodyElement(name, full);
    }

    private Content getContent(MessageResult messageResult, Optional<MimePath> path) throws MailboxException {
        if (path.isEmpty()) {
            try {
                return messageResult.getFullContent();
            }
            catch (IOException e) {
                throw new MailboxException("Unable to get content", (Throwable)e);
            }
        }
        return messageResult.getMimeBody(path.get());
    }
}

