/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProcessor
extends AbstractMailboxProcessor<ListRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListProcessor.class);

    public ListProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(ListRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(ListRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String baseReferenceName = request.getBaseReferenceName();
        String mailboxPatternString = request.getMailboxPattern();
        MailboxSession mailboxSession = session.getMailboxSession();
        try {
            if (mailboxPatternString.length() == 0) {
                this.respondNamespace(baseReferenceName, responder, mailboxSession);
            } else {
                this.respondMailboxList(baseReferenceName, mailboxPatternString, session, responder, mailboxSession);
            }
            this.okComplete(request, responder);
        }
        catch (MailboxException e) {
            LOGGER.error("List failed for mailboxName {}", (Object)mailboxPatternString, (Object)e);
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    protected ImapResponseMessage createResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, MailboxType type) {
        return new ListResponse(children, selectability, name, hierarchyDelimiter);
    }

    private void respondNamespace(String referenceName, ImapProcessor.Responder responder, MailboxSession mailboxSession) {
        String referenceRoot = ModifiedUtf7.decodeModifiedUTF7(this.computeReferenceRoot(referenceName, mailboxSession));
        responder.respond(this.createResponse(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.NOSELECT, referenceRoot, mailboxSession.getPathDelimiter(), MailboxType.OTHER));
    }

    private String computeReferenceRoot(String referenceName, MailboxSession mailboxSession) {
        if (referenceName.length() > 0 && referenceName.charAt(0) == '#') {
            int firstDelimiter = referenceName.indexOf(mailboxSession.getPathDelimiter());
            if (firstDelimiter == -1) {
                return referenceName;
            }
            return referenceName.substring(0, firstDelimiter);
        }
        return "";
    }

    private void respondMailboxList(String referenceName, String mailboxName, ImapSession session, ImapProcessor.Responder responder, MailboxSession mailboxSession) throws MailboxException {
        String finalReferencename = referenceName;
        if (mailboxName.charAt(0) == '#') {
            finalReferencename = "";
        }
        boolean isRelative = (finalReferencename + mailboxName).charAt(0) != '#';
        MailboxPath basePath = this.computeBasePath(session, finalReferencename, isRelative);
        this.getMailboxManager().search(MailboxQuery.builder().userAndNamespaceFrom(basePath).expression((MailboxNameExpression)new PrefixedRegex(basePath.getName(), ModifiedUtf7.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession).doOnNext(metaData -> this.processResult(responder, isRelative, (MailboxMetaData)metaData, this.getMailboxType(session, metaData.getPath()))).then().block();
    }

    private MailboxPath computeBasePath(ImapSession session, String finalReferencename, boolean isRelative) {
        String decodedName = ModifiedUtf7.decodeModifiedUTF7(finalReferencename);
        if (isRelative) {
            return MailboxPath.forUser((Username)session.getUserName(), (String)decodedName);
        }
        return PathConverter.forSession(session).buildFullPath(decodedName);
    }

    private void processResult(ImapProcessor.Responder responder, boolean relative, MailboxMetaData listResult, MailboxType mailboxType) {
        String mailboxName = this.mailboxName(relative, listResult.getPath(), listResult.getHierarchyDelimiter());
        ImapResponseMessage response = this.createResponse(listResult.inferiors(), listResult.getSelectability(), mailboxName, listResult.getHierarchyDelimiter(), mailboxType);
        responder.respond(response);
    }

    protected MailboxType getMailboxType(ImapSession session, MailboxPath path) {
        return MailboxType.OTHER;
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return ListRequest.class.equals(message.getClass());
    }

    @Override
    protected Closeable addContextToMDC(ListRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"LIST").addContext("base", (Object)request.getBaseReferenceName()).addContext("pattern", (Object)request.getMailboxPattern()).build();
    }
}

