/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.github.steveash.guavate.Guavate;
import java.time.Clock;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.decode.parser.AppendCommandParser;
import org.apache.james.imap.decode.parser.AuthenticateCommandParser;
import org.apache.james.imap.decode.parser.CapabilityCommandParser;
import org.apache.james.imap.decode.parser.CheckCommandParser;
import org.apache.james.imap.decode.parser.CloseCommandParser;
import org.apache.james.imap.decode.parser.CompressCommandParser;
import org.apache.james.imap.decode.parser.CopyCommandParser;
import org.apache.james.imap.decode.parser.CreateCommandParser;
import org.apache.james.imap.decode.parser.DeleteACLCommandParser;
import org.apache.james.imap.decode.parser.DeleteCommandParser;
import org.apache.james.imap.decode.parser.EnableCommandParser;
import org.apache.james.imap.decode.parser.ExamineCommandParser;
import org.apache.james.imap.decode.parser.ExpungeCommandParser;
import org.apache.james.imap.decode.parser.FetchCommandParser;
import org.apache.james.imap.decode.parser.GetACLCommandParser;
import org.apache.james.imap.decode.parser.GetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaRootCommandParser;
import org.apache.james.imap.decode.parser.IdleCommandParser;
import org.apache.james.imap.decode.parser.ListCommandParser;
import org.apache.james.imap.decode.parser.ListRightsCommandParser;
import org.apache.james.imap.decode.parser.LoginCommandParser;
import org.apache.james.imap.decode.parser.LogoutCommandParser;
import org.apache.james.imap.decode.parser.LsubCommandParser;
import org.apache.james.imap.decode.parser.MoveCommandParser;
import org.apache.james.imap.decode.parser.MyRightsCommandParser;
import org.apache.james.imap.decode.parser.NamespaceCommandParser;
import org.apache.james.imap.decode.parser.NoopCommandParser;
import org.apache.james.imap.decode.parser.RenameCommandParser;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.apache.james.imap.decode.parser.SelectCommandParser;
import org.apache.james.imap.decode.parser.SetACLCommandParser;
import org.apache.james.imap.decode.parser.SetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.SetQuotaCommandParser;
import org.apache.james.imap.decode.parser.StartTLSCommandParser;
import org.apache.james.imap.decode.parser.StatusCommandParser;
import org.apache.james.imap.decode.parser.StoreCommandParser;
import org.apache.james.imap.decode.parser.SubscribeCommandParser;
import org.apache.james.imap.decode.parser.UidCommandParser;
import org.apache.james.imap.decode.parser.UnselectCommandParser;
import org.apache.james.imap.decode.parser.UnsubscribeCommandParser;
import org.apache.james.imap.decode.parser.XListCommandParser;

public class ImapParserFactory
implements ImapCommandParserFactory {
    private final Map<String, ImapCommandParser> imapCommands;

    public ImapParserFactory(StatusResponseFactory statusResponseFactory) {
        Stream<AbstractImapCommandParser> parsers = Stream.of(new CapabilityCommandParser(statusResponseFactory), new NoopCommandParser(statusResponseFactory), new LogoutCommandParser(statusResponseFactory), new AuthenticateCommandParser(statusResponseFactory), new LoginCommandParser(statusResponseFactory), new SelectCommandParser(statusResponseFactory), new ExamineCommandParser(statusResponseFactory), new CreateCommandParser(statusResponseFactory), new DeleteCommandParser(statusResponseFactory), new RenameCommandParser(statusResponseFactory), new SubscribeCommandParser(statusResponseFactory), new UnsubscribeCommandParser(statusResponseFactory), new ListCommandParser(statusResponseFactory), new XListCommandParser(statusResponseFactory), new LsubCommandParser(statusResponseFactory), new StatusCommandParser(statusResponseFactory), new AppendCommandParser(statusResponseFactory, Clock.systemDefaultZone()), new NamespaceCommandParser(statusResponseFactory), new GetACLCommandParser(statusResponseFactory), new SetACLCommandParser(statusResponseFactory), new DeleteACLCommandParser(statusResponseFactory), new ListRightsCommandParser(statusResponseFactory), new MyRightsCommandParser(statusResponseFactory), new CheckCommandParser(statusResponseFactory), new CloseCommandParser(statusResponseFactory), new ExpungeCommandParser(statusResponseFactory), new CopyCommandParser(statusResponseFactory), new MoveCommandParser(statusResponseFactory), new SearchCommandParser(statusResponseFactory), new FetchCommandParser(statusResponseFactory), new StoreCommandParser(statusResponseFactory), new UidCommandParser(this, statusResponseFactory), new IdleCommandParser(statusResponseFactory), new StartTLSCommandParser(statusResponseFactory), new UnselectCommandParser(statusResponseFactory), new CompressCommandParser(statusResponseFactory), new EnableCommandParser(statusResponseFactory), new GetQuotaRootCommandParser(statusResponseFactory), new GetQuotaCommandParser(statusResponseFactory), new SetQuotaCommandParser(statusResponseFactory), new SetAnnotationCommandParser(statusResponseFactory), new GetAnnotationCommandParser(statusResponseFactory));
        this.imapCommands = (Map)parsers.collect(Guavate.toImmutableMap(parser -> parser.getCommand().getName(), Function.identity()));
    }

    @Override
    public ImapCommandParser getParser(String commandName) {
        return this.imapCommands.get(commandName.toUpperCase(Locale.US));
    }
}

