/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message.response;

import com.github.steveash.guavate.Guavate;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.MessageFlags;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.UidValidity;

public interface StatusResponse
extends ImapResponseMessage {
    public static final Set<String> AVAILABLE_CHARSET_NAMES = (Set)Charset.availableCharsets().values().stream().flatMap(charset -> Stream.concat(Stream.of(charset.name()), charset.aliases().stream())).collect(Guavate.toImmutableSet());

    public Type getServerResponseType();

    public Tag getTag();

    public ImapCommand getCommand();

    public HumanReadableText getTextKey();

    public ResponseCode getResponseCode();

    public static final class ResponseCode {
        private static final ResponseCode ALERT = new ResponseCode("ALERT");
        private static final ResponseCode PARSE = new ResponseCode("PARSE");
        private static final ResponseCode READ_ONLY = new ResponseCode("READ-ONLY");
        private static final ResponseCode READ_WRITE = new ResponseCode("READ-WRITE");
        private static final ResponseCode TRYCREATE = new ResponseCode("TRYCREATE");
        private static final ResponseCode CLOSED = new ResponseCode("CLOSED");
        public static final int NO_NUMBER = -1;
        private final String code;
        private final Collection<String> parameters;
        private final long number;
        private final boolean useParens;

        public static ResponseCode appendUid(UidValidity uidValidity, UidRange[] uids) {
            String uidParam = ResponseCode.formatRanges(uids);
            return new ResponseCode("APPENDUID", Arrays.asList(uidParam), uidValidity.asLong(), false);
        }

        public static ResponseCode copyUid(UidValidity uidValidity, IdRange[] sourceRanges, IdRange[] targetRanges) {
            String source = ResponseCode.formatRanges(sourceRanges);
            String target = ResponseCode.formatRanges(targetRanges);
            return new ResponseCode("COPYUID", Arrays.asList(source, target), uidValidity.asLong(), false);
        }

        public static ResponseCode condStore(IdRange[] failedRanges) {
            String failed = ResponseCode.formatRanges(failedRanges);
            return new ResponseCode("MODIFIED", Arrays.asList(failed), 0L, false);
        }

        public static ResponseCode condStore(UidRange[] failedRanges) {
            String failed = ResponseCode.formatRanges(failedRanges);
            return new ResponseCode("MODIFIED", Arrays.asList(failed), 0L, false);
        }

        private static String formatRanges(IdRange[] ranges) {
            if (ranges == null || ranges.length == 0) {
                return "*";
            }
            StringBuilder rangeBuilder = new StringBuilder();
            for (int i = 0; i < ranges.length; ++i) {
                rangeBuilder.append(ranges[i].getFormattedString());
                if (i + 1 >= ranges.length) continue;
                rangeBuilder.append(",");
            }
            return rangeBuilder.toString();
        }

        private static String formatRanges(UidRange[] ranges) {
            if (ranges == null || ranges.length == 0) {
                return "*";
            }
            StringBuilder rangeBuilder = new StringBuilder();
            for (int i = 0; i < ranges.length; ++i) {
                rangeBuilder.append(ranges[i].getFormattedString());
                if (i + 1 >= ranges.length) continue;
                rangeBuilder.append(",");
            }
            return rangeBuilder.toString();
        }

        public static ResponseCode closed() {
            return CLOSED;
        }

        public static ResponseCode alert() {
            return ALERT;
        }

        public static ResponseCode badCharset() {
            return new ResponseCode("BADCHARSET", AVAILABLE_CHARSET_NAMES);
        }

        public static ResponseCode parse() {
            return PARSE;
        }

        public static ResponseCode permanentFlags(Flags flags) {
            return new ResponseCode("PERMANENTFLAGS", MessageFlags.names(flags));
        }

        public static ResponseCode readOnly() {
            return READ_ONLY;
        }

        public static ResponseCode readWrite() {
            return READ_WRITE;
        }

        public static ResponseCode tryCreate() {
            return TRYCREATE;
        }

        public static ResponseCode uidValidity(UidValidity uid) {
            return new ResponseCode("UIDVALIDITY", uid.asLong());
        }

        public static ResponseCode unseen(MessageSequenceNumber numberUnseen) {
            return new ResponseCode("UNSEEN", numberUnseen.asInt());
        }

        public static ResponseCode uidNext(MessageUid uid) {
            return new ResponseCode("UIDNEXT", uid.asLong());
        }

        public static ResponseCode highestModSeq(ModSeq modSeq) {
            return new ResponseCode("HIGHESTMODSEQ", modSeq.asLong());
        }

        public static ResponseCode longestMetadataEntry(long entryLong) {
            return new ResponseCode("METADATA LONGENTRIES", entryLong);
        }

        public static ResponseCode noModSeq() {
            return new ResponseCode("NOMODSEQ");
        }

        public static ResponseCode createExtension(String name) {
            StringBuilder builder = new StringBuilder(name.length() + 2);
            if (!name.startsWith("X")) {
                builder.append('X');
            }
            builder.append(name);
            return new ResponseCode(builder.toString());
        }

        private ResponseCode(String code) {
            this(code, Collections.emptyList(), -1L, true);
        }

        private ResponseCode(String code, long number) {
            this(code, Collections.emptyList(), number, true);
        }

        private ResponseCode(String code, Collection<String> parameters) {
            this(code, parameters, -1L, true);
        }

        private ResponseCode(String code, Collection<String> parameters, long number, boolean useParens) {
            this.useParens = useParens;
            this.code = code;
            this.parameters = parameters;
            this.number = number;
        }

        public String getCode() {
            return this.code;
        }

        public long getNumber() {
            return this.number;
        }

        public boolean useParens() {
            return this.useParens;
        }

        public Collection<String> getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (int)(this.number ^ this.number >>> 32);
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseCode other = (ResponseCode)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            if (this.number != other.number) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }

        public String toString() {
            return this.code;
        }
    }

    public static enum Type {
        OK("OK"),
        NO("NO"),
        BAD("BAD"),
        PREAUTH("PREAUTH"),
        BYE("BYE");

        private final String code;

        private Type(String code) {
            this.code = code;
        }

        public final String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }
    }
}

