/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.base.Strings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import java.security.Key;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenVerifier.class);
    private final PublicKeyProvider pubKeyProvider;

    public static JwtTokenVerifier create(JwtConfiguration jwtConfiguration) {
        PublicKeyProvider publicKeyProvider = new PublicKeyProvider(jwtConfiguration, new PublicKeyReader());
        return new JwtTokenVerifier(publicKeyProvider);
    }

    public JwtTokenVerifier(PublicKeyProvider pubKeyProvider) {
        this.pubKeyProvider = pubKeyProvider;
    }

    public boolean verify(String token) {
        try {
            String subject = this.extractLogin(token);
            if (Strings.isNullOrEmpty((String)subject)) {
                throw new MalformedJwtException("'subject' field in token is mandatory");
            }
            return true;
        }
        catch (JwtException e) {
            LOGGER.info("Failed Jwt verification", (Throwable)e);
            return false;
        }
    }

    public String extractLogin(String token) throws JwtException {
        Jws<Claims> jws = this.parseToken(token);
        return ((Claims)jws.getBody()).getSubject();
    }

    public boolean hasAttribute(String attributeName, Object expectedValue, String token) {
        try {
            Jwts.parser().require(attributeName, expectedValue).setSigningKey((Key)this.pubKeyProvider.get()).parseClaimsJws(token);
            return true;
        }
        catch (JwtException e) {
            LOGGER.info("Jwt validation failed for claim {} to {}", new Object[]{attributeName, expectedValue, e});
            return false;
        }
    }

    private Jws<Claims> parseToken(String token) throws JwtException {
        return Jwts.parser().setSigningKey((Key)this.pubKeyProvider.get()).parseClaimsJws(token);
    }

    public static interface Factory {
        public JwtTokenVerifier create();
    }
}

