/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.Version;
import reactor.netty.http.server.HttpServerRequest;

public class VersionParser {
    private static final String JMAP_VERSION_HEADER = "jmapVersion";
    private final Set<Version> supportedVersions;
    private final JMAPConfiguration jmapConfiguration;

    @Inject
    public VersionParser(Set<Version> supportedVersions, JMAPConfiguration jmapConfiguration) {
        this.jmapConfiguration = jmapConfiguration;
        Preconditions.checkArgument((boolean)supportedVersions.contains(jmapConfiguration.getDefaultVersion()), (Object)(jmapConfiguration + " is not a supported JMAP version"));
        this.supportedVersions = supportedVersions;
    }

    @VisibleForTesting
    Version parse(String version) {
        Preconditions.checkNotNull((Object)version);
        return this.supportedVersions.stream().filter(jmapVersion -> jmapVersion.asString().equalsIgnoreCase(version)).findFirst().orElseThrow(() -> new IllegalArgumentException(version + " is not a supported version"));
    }

    Version parseRequestVersionHeader(HttpServerRequest request) {
        return this.asVersion(request).filter(nameValuePair -> nameValuePair.getName().equals(JMAP_VERSION_HEADER)).map(NameValuePair::getValue).map(this::parse).findFirst().orElse(this.jmapConfiguration.getDefaultVersion());
    }

    private Stream<NameValuePair> asVersion(HttpServerRequest request) {
        return request.requestHeaders().getAll((CharSequence)HttpHeaderNames.ACCEPT).stream().flatMap(this::extractValueParameters);
    }

    private Stream<NameValuePair> extractValueParameters(String value) {
        return Arrays.stream(BasicHeaderValueParser.parseParameters((String)value, (HeaderValueParser)BasicHeaderValueParser.INSTANCE));
    }
}

