/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.Instant;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.Dequeuer;
import org.apache.james.queue.rabbitmq.Enqueuer;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.api.DeleteCondition;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class RabbitMQMailQueue
implements ManageableMailQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQMailQueue.class);
    private final MailQueueName name;
    private final MetricFactory metricFactory;
    private final Enqueuer enqueuer;
    private final Dequeuer dequeuer;
    private final MailQueueView<CassandraMailQueueBrowser.CassandraMailQueueItemView> mailQueueView;
    private final MailQueueItemDecoratorFactory decoratorFactory;

    RabbitMQMailQueue(MetricFactory metricFactory, MailQueueName name, Enqueuer enqueuer, Dequeuer dequeuer, MailQueueView<CassandraMailQueueBrowser.CassandraMailQueueItemView> mailQueueView, MailQueueItemDecoratorFactory decoratorFactory) {
        this.metricFactory = metricFactory;
        this.name = name;
        this.enqueuer = enqueuer;
        this.dequeuer = dequeuer;
        this.mailQueueView = mailQueueView;
        this.decoratorFactory = decoratorFactory;
    }

    public void close() {
        this.dequeuer.close();
    }

    public org.apache.james.queue.api.MailQueueName getName() {
        return org.apache.james.queue.api.MailQueueName.of((String)this.name.asString());
    }

    public void enQueue(Mail mail, Duration delay) {
        if (!delay.isNegative()) {
            LOGGER.info("Ignored delay upon enqueue of {} : {}.", (Object)mail.getName(), (Object)delay);
        }
        this.enQueue(mail);
    }

    public void enQueue(Mail mail) {
        this.metricFactory.runPublishingTimerMetric("enqueueTime:" + this.name.asString(), Throwing.runnable(() -> this.enqueuer.enQueue(mail)).sneakyThrow());
    }

    public Flux<MailQueue.MailQueueItem> deQueue() {
        return this.dequeuer.deQueue().map(item -> this.decoratorFactory.decorate(item, this.name.toModel()));
    }

    public long getSize() {
        return this.mailQueueView.getSize();
    }

    public long flush() {
        LOGGER.warn("Delays are not supported by RabbitMQ. Flush is a NOOP.");
        return 0L;
    }

    public long clear() {
        return this.mailQueueView.delete(DeleteCondition.all());
    }

    public long remove(ManageableMailQueue.Type type, String value) {
        return this.mailQueueView.delete(DeleteCondition.from(type, value));
    }

    public ManageableMailQueue.MailQueueIterator browse() {
        return this.mailQueueView.browse();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    public Flux<String> republishNotProcessedMails(Instant olderThan) {
        Function requeue = item -> this.enqueuer.reQueue((CassandraMailQueueBrowser.CassandraMailQueueItemView)item).thenReturn((Object)item.getMail().getName());
        return this.mailQueueView.browseOlderThanReactive(olderThan).flatMap((java.util.function.Function)requeue, 16);
    }
}

