/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatCmdHandler
implements CommandHandler<POP3Session> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"STAT");
    private final MetricFactory metricFactory;

    @Inject
    public StatCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-stat", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("action", (Object)"STAT").addContext(MDCConstants.withSession(session)), () -> this.stat(session)));
    }

    private Response stat(POP3Session session) {
        LOGGER.trace("STAT command received");
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            long size = 0L;
            int count = 0;
            if (!uidList.isEmpty()) {
                ArrayList<MessageMetaData> validResults = new ArrayList<MessageMetaData>();
                for (MessageMetaData data : uidList) {
                    if (deletedUidList.contains(data.getUid())) continue;
                    size += data.getSize();
                    ++count;
                    validResults.add(data);
                }
            }
            StringBuilder responseBuffer = new StringBuilder(32).append(count).append(" ").append(size);
            return new POP3Response("+OK", responseBuffer.toString());
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

