/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.URISupport;

public class InterceptSendToEndpointReifier
extends ProcessorReifier<InterceptSendToEndpointDefinition> {
    public InterceptSendToEndpointReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (InterceptSendToEndpointDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        final Processor before = this.createChildProcessor(true);
        Processor afterProcessor = null;
        if (((InterceptSendToEndpointDefinition)this.definition).getAfterUri() != null) {
            ToDefinition to = new ToDefinition(this.parseString(((InterceptSendToEndpointDefinition)this.definition).getAfterUri()));
            afterProcessor = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getProcessorFactory().createProcessor(this.route, (NamedNode)to);
            if (afterProcessor == null) {
                afterProcessor = this.createProcessor((ProcessorDefinition<?>)to);
            }
        }
        final Processor after = afterProcessor;
        final String matchURI = this.parseString(((InterceptSendToEndpointDefinition)this.definition).getUri());
        ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).registerEndpointCallback(new EndpointStrategy(){

            public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
                if (endpoint instanceof InterceptSendToEndpoint) {
                    return endpoint;
                }
                if (matchURI == null || InterceptSendToEndpointReifier.this.matchPattern(uri, matchURI)) {
                    boolean skip = InterceptSendToEndpointReifier.this.parseBoolean(((InterceptSendToEndpointDefinition)InterceptSendToEndpointReifier.this.definition).getSkipSendToOriginalEndpoint(), false);
                    return ((ExtendedCamelContext)InterceptSendToEndpointReifier.this.camelContext.adapt(ExtendedCamelContext.class)).getInterceptEndpointFactory().createInterceptSendToEndpoint(InterceptSendToEndpointReifier.this.camelContext, endpoint, skip, before, after);
                }
                return endpoint;
            }
        });
        RouteDefinition route = (RouteDefinition)this.route.getRoute();
        List outputs = route.getOutputs();
        outputs.remove(this.definition);
        return new InterceptEndpointProcessor(matchURI, before);
    }

    protected boolean matchPattern(String uri, String pattern) {
        boolean match = EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)uri, (String)pattern);
        if (!match) {
            try {
                pattern = URISupport.normalizeUri((String)pattern);
                match = EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)uri, (String)pattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return match;
    }
}

