/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoAPI;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MergingCassandraMailRepositoryMailDao
implements CassandraMailRepositoryMailDaoAPI {
    private final CassandraMailRepositoryMailDAO v1;
    private final CassandraMailRepositoryMailDaoV2 v2;

    @Inject
    @VisibleForTesting
    MergingCassandraMailRepositoryMailDao(CassandraMailRepositoryMailDAO v1, CassandraMailRepositoryMailDaoV2 v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public Mono<Void> store(MailRepositoryUrl url, Mail mail, BlobId headerId, BlobId bodyId) {
        return this.v2.store(url, mail, headerId, bodyId);
    }

    @Override
    public Mono<Void> remove(MailRepositoryUrl url, MailKey key) {
        return Flux.merge((Publisher[])new Publisher[]{this.v1.remove(url, key), this.v2.remove(url, key)}).then();
    }

    @Override
    public Mono<Optional<CassandraMailRepositoryMailDaoAPI.MailDTO>> read(MailRepositoryUrl url, MailKey key) {
        return this.v2.read(url, key).filter(Optional::isPresent).switchIfEmpty(this.v1.read(url, key));
    }
}

