/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import java.util.Objects;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import reactor.core.publisher.Mono;

public interface CassandraMailRepositoryMailDaoAPI {
    public Mono<Void> store(MailRepositoryUrl var1, Mail var2, BlobId var3, BlobId var4);

    public Mono<Void> remove(MailRepositoryUrl var1, MailKey var2);

    public Mono<Optional<MailDTO>> read(MailRepositoryUrl var1, MailKey var2);

    public static class MailDTO {
        private final MailImpl.Builder mailBuilder;
        private final BlobId headerBlobId;
        private final BlobId bodyBlobId;

        public MailDTO(MailImpl.Builder mailBuilder, BlobId headerBlobId, BlobId bodyBlobId) {
            this.mailBuilder = mailBuilder;
            this.headerBlobId = headerBlobId;
            this.bodyBlobId = bodyBlobId;
        }

        public MailImpl.Builder getMailBuilder() {
            return this.mailBuilder;
        }

        public BlobId getHeaderBlobId() {
            return this.headerBlobId;
        }

        public BlobId getBodyBlobId() {
            return this.bodyBlobId;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailDTO) {
                MailDTO mailDTO = (MailDTO)o;
                return Objects.equals(this.mailBuilder.build(), mailDTO.mailBuilder.build()) && Objects.equals(this.headerBlobId, mailDTO.headerBlobId) && Objects.equals(this.bodyBlobId, mailDTO.bodyBlobId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailBuilder.build(), this.headerBlobId, this.bodyBlobId);
        }
    }
}

