/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.dto.MailboxResponse;
import org.apache.james.webadmin.utils.MailboxHaveChildrenException;
import org.apache.james.webadmin.validation.MailboxName;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class UserMailboxesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMailboxesService.class);
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    public UserMailboxesService(MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    public void createMailbox(Username username, MailboxName mailboxName) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        try {
            MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
            this.mailboxManager.createMailbox(mailboxPath, mailboxSession);
        }
        catch (MailboxExistsException e) {
            LOGGER.info("Attempt to create mailbox {} for user {} that already exists", (Object)mailboxName, (Object)username);
        }
    }

    public void deleteMailboxes(Username username) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        this.listUserMailboxes(mailboxSession).map(MailboxMetaData::getPath).forEach((Consumer<MailboxPath>)Throwing.consumer(mailboxPath -> this.deleteMailbox(mailboxSession, (MailboxPath)mailboxPath)));
    }

    public List<MailboxResponse> listMailboxes(Username username) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        return (List)this.listUserMailboxes(mailboxSession).map(mailboxMetaData -> new MailboxResponse(mailboxMetaData.getPath().getName(), mailboxMetaData.getId())).collect(Guavate.toImmutableList());
    }

    public boolean testMailboxExists(Username username, MailboxName mailboxName) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
        return (Boolean)Mono.from((Publisher)this.mailboxManager.mailboxExists(mailboxPath, mailboxSession)).block();
    }

    public void deleteMailbox(Username username, MailboxName mailboxName) throws MailboxException, UsersRepositoryException, MailboxHaveChildrenException {
        this.usernamePreconditions(username);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
        this.listChildren(mailboxPath, mailboxSession).forEach((Consumer<MailboxPath>)Throwing.consumer(path -> this.deleteMailbox(mailboxSession, (MailboxPath)path)));
    }

    private Stream<MailboxPath> listChildren(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        return this.listUserMailboxes(mailboxSession).map(MailboxMetaData::getPath).filter(path -> path.getHierarchyLevels(mailboxSession.getPathDelimiter()).contains(mailboxPath));
    }

    private void deleteMailbox(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        try {
            this.mailboxManager.deleteMailbox(mailboxPath, mailboxSession);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.info("Attempt to delete mailbox {} for user {} that does not exists", (Object)mailboxPath.getName(), (Object)mailboxPath.getUser());
        }
    }

    private void usernamePreconditions(Username username) throws UsersRepositoryException {
        Preconditions.checkState((boolean)this.usersRepository.contains(username), (Object)"User does not exist");
    }

    private Stream<MailboxMetaData> listUserMailboxes(MailboxSession mailboxSession) throws MailboxException {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)mailboxSession).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession).toStream();
    }
}

