/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.QuotaDomainDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.service.DomainQuotaService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.QuotaDTOValidator;
import org.apache.james.webadmin.validation.Quotas;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"DomainQuota"})
@Path(value="/quota/domains/:domain")
@Produces(value={"application/json"})
public class DomainQuotaRoutes
implements Routes {
    private static final String DOMAIN = "domain";
    public static final String BASE_PATH = "/quota/domains";
    static final String QUOTA_ENDPOINT = "/quota/domains/:domain";
    private static final String COUNT_ENDPOINT = "/quota/domains/:domain/count";
    private static final String SIZE_ENDPOINT = "/quota/domains/:domain/size";
    private final DomainList domainList;
    private final DomainQuotaService domainQuotaService;
    private final UsersRepository usersRepository;
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<QuotaDTO> jsonExtractor;
    private final QuotaDTOValidator quotaDTOValidator;
    private Service service;

    @Inject
    public DomainQuotaRoutes(DomainList domainList, DomainQuotaService domainQuotaService, UsersRepository usersRepository, JsonTransformer jsonTransformer, Set<JsonTransformerModule> modules) {
        this.domainList = domainList;
        this.domainQuotaService = domainQuotaService;
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(QuotaDTO.class, modules.stream().map(JsonTransformerModule::asJacksonModule).collect(Collectors.toList()));
        this.quotaDTOValidator = new QuotaDTOValidator();
    }

    public String getBasePath() {
        return QUOTA_ENDPOINT;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetQuotaCount();
        this.defineDeleteQuotaCount();
        this.defineUpdateQuotaCount();
        this.defineGetQuotaSize();
        this.defineDeleteQuotaSize();
        this.defineUpdateQuotaSize();
        this.defineGetQuota();
        this.defineUpdateQuota();
    }

    public boolean isVirtualHostingSupported() {
        try {
            return this.usersRepository.supportVirtualHosting();
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @PUT
    @ApiOperation(value="Updating count and size at the same time")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataTypeClass=QuotaDTO.class, paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer or not unlimited value (-1)."), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuota() {
        this.service.put(QUOTA_ENDPOINT, (request, response) -> {
            try {
                Domain domain = this.checkDomainExist(request);
                QuotaDTO quotaDTO = (QuotaDTO)this.jsonExtractor.parse(request.body());
                ValidatedQuotaDTO validatedQuotaDTO = this.quotaDTOValidator.validatedQuotaDTO(quotaDTO);
                this.domainQuotaService.defineQuota(domain, validatedQuotaDTO);
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalArgumentException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
            }
        });
    }

    @GET
    @ApiOperation(value="Reading count and size at the same time", notes="If there is no limitation for count and/or size, the returned value will be -1")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QuotaDomainDTO.class), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuota() {
        this.service.get(QUOTA_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            return this.domainQuotaService.getQuota(domain);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/size")
    @ApiOperation(value="Removing per domain mail size limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaSize() {
        this.service.delete(SIZE_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            this.domainQuotaService.remoteMaxQuotaSize(domain);
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/size")
    @ApiOperation(value="Updating per domain mail size limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaSize() {
        this.service.put(SIZE_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            QuotaSizeLimit quotaSize = Quotas.quotaSize(request.body());
            this.domainQuotaService.setMaxSizeQuota(domain, quotaSize);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/size")
    @ApiOperation(value="Reading per domain mail size limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="No value defined"), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaSize() {
        this.service.get(SIZE_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            Optional<QuotaSizeLimit> maxSizeQuota = this.domainQuotaService.getMaxSizeQuota(domain);
            if (maxSizeQuota.isPresent()) {
                return maxSizeQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/count")
    @ApiOperation(value="Removing per domain mail count limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaCount() {
        this.service.delete(COUNT_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            this.domainQuotaService.remoteMaxQuotaCount(domain);
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/count")
    @ApiOperation(value="Updating per domain mail count limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer."), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaCount() {
        this.service.put(COUNT_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            QuotaCountLimit quotaCount = Quotas.quotaCount(request.body());
            this.domainQuotaService.setMaxCountQuota(domain, quotaCount);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/count")
    @ApiOperation(value="Reading per domain mail count limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=404, message="The requested domain can not be found."), @ApiResponse(code=405, message="Domain Quota configuration not supported when virtual hosting is desactivated."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaCount() {
        this.service.get(COUNT_ENDPOINT, (request, response) -> {
            Domain domain = this.checkDomainExist(request);
            Optional<QuotaCountLimit> maxCountQuota = this.domainQuotaService.getMaxCountQuota(domain);
            if (maxCountQuota.isPresent()) {
                return maxCountQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    private Domain checkDomainExist(Request request) {
        if (!this.isVirtualHostingSupported()) {
            throw ErrorResponder.builder().statusCode(405).type(ErrorResponder.ErrorType.WRONG_STATE).message("Domain Quota configuration not supported when virtual hosting is desactivated. Please use global quota configuration instead").haltError();
        }
        try {
            Domain domain = Domain.of((String)request.params(DOMAIN));
            if (!this.domainList.containsDomain(domain)) {
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Domain not found").haltError();
            }
            return domain;
        }
        catch (DomainListException e) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).cause((Exception)((Object)e)).haltError();
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid domain").cause((Exception)e).haltError();
        }
    }
}

