/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.webadmin;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.apache.james.backends.cassandra.migration.CassandraMigrationService;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaTransition;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.mailbox.cassandra.mail.migration.AclV2Migration;
import org.apache.james.mailbox.cassandra.mail.migration.MailboxPathV2Migration;
import org.apache.james.mailbox.cassandra.mail.migration.MailboxPathV3Migration;
import org.apache.james.mailbox.cassandra.mail.migration.MessageV3Migration;
import org.apache.james.rrt.cassandra.migration.MappingsSourcesMigration;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.CassandraMailboxMergingRoutes;
import org.apache.james.webadmin.routes.CassandraMigrationRoutes;

public class CassandraRoutesModule
extends AbstractModule {
    private static final SchemaTransition FROM_V5_TO_V6 = SchemaTransition.to((SchemaVersion)new SchemaVersion(6));
    private static final SchemaTransition FROM_V6_TO_V7 = SchemaTransition.to((SchemaVersion)new SchemaVersion(7));
    private static final SchemaTransition FROM_V7_TO_V8 = SchemaTransition.to((SchemaVersion)new SchemaVersion(8));
    private static final SchemaTransition FROM_V8_TO_V9 = SchemaTransition.to((SchemaVersion)new SchemaVersion(9));
    private static final SchemaTransition FROM_V9_TO_V10 = SchemaTransition.to((SchemaVersion)new SchemaVersion(10));

    protected void configure() {
        this.bind(MigrationTask.Impl.class).in(Scopes.SINGLETON);
        this.bind(CassandraRoutesModule.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxMergingRoutes.class).in(Scopes.SINGLETON);
        this.bind(CassandraMigrationService.class).in(Scopes.SINGLETON);
        this.bind(MigrationTask.Factory.class).to(MigrationTask.Impl.class);
        Multibinder routesMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Routes.class);
        routesMultibinder.addBinding().to(CassandraMigrationRoutes.class);
        routesMultibinder.addBinding().to(CassandraMailboxMergingRoutes.class);
        MapBinder allMigrationClazzBinder = MapBinder.newMapBinder((Binder)this.binder(), SchemaTransition.class, Migration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V5_TO_V6).to(MailboxPathV2Migration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V6_TO_V7).to(MappingsSourcesMigration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V7_TO_V8).to(MailboxPathV3Migration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V8_TO_V9).to(MessageV3Migration.class);
        allMigrationClazzBinder.addBinding((Object)FROM_V9_TO_V10).to(AclV2Migration.class);
        this.bind(SchemaVersion.class).annotatedWith((Annotation)Names.named((String)"latestVersion")).toInstance((Object)CassandraSchemaVersionManager.MAX_VERSION);
    }
}

