/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events.delivery;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InVmEventDelivery
implements EventDelivery {
    private static final Logger LOGGER = LoggerFactory.getLogger(InVmEventDelivery.class);
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    public InVmEventDelivery(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Mono<Void> deliver(EventListener.ReactiveEventListener listener, Event event, EventDelivery.DeliveryOption option) {
        Mono<Void> executionResult = this.deliverByOption(listener, event, option);
        return this.waitForResultIfNeeded(listener.getExecutionMode(), executionResult);
    }

    private Mono<Void> waitForResultIfNeeded(EventListener.ExecutionMode executionMode, Mono<Void> executionResult) {
        if (executionMode.equals((Object)EventListener.ExecutionMode.SYNCHRONOUS)) {
            return executionResult;
        }
        return Flux.merge((Publisher[])new Publisher[]{executionResult, Mono.empty()}).publishNext().onErrorResume(throwable -> Mono.empty());
    }

    private Mono<Void> deliverByOption(EventListener.ReactiveEventListener listener, Event event, EventDelivery.DeliveryOption deliveryOption) {
        Mono deliveryToListener = this.doDeliverToListener(listener, event).doOnError(throwable -> this.structuredLogger(event, (EventListener)listener).log(logger -> logger.error("Error while processing listener", throwable))).then();
        return deliveryOption.getRetrier().doRetry((Mono<Void>)deliveryToListener, event).onErrorResume(throwable -> deliveryOption.getPermanentFailureHandler().handle(event)).then();
    }

    private Mono<Void> doDeliverToListener(EventListener.ReactiveEventListener listener, Event event) {
        if (listener.isHandling(event)) {
            return Mono.defer(() -> Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(EventBus.Metrics.timerName((EventListener)listener), listener.reactiveEvent(event)))).subscriberContext(ReactorUtils.context((String)"deliver", (MDCBuilder)this.buildMDC((EventListener)listener, event)));
        }
        return Mono.empty();
    }

    private MDCBuilder buildMDC(EventListener listener, Event event) {
        return MDCBuilder.create().addContext("eventId", (Object)event.getEventId()).addContext("eventClass", event.getClass()).addContext("user", (Object)event.getUsername()).addContext("listenerClass", listener.getClass());
    }

    private StructuredLogger structuredLogger(Event event, EventListener listener) {
        return MDCStructuredLogger.forLogger((Logger)LOGGER).addField("eventId", (Object)event.getEventId()).addField("eventClass", event.getClass()).addField("user", (Object)event.getUsername()).addField("listenerClass", listener.getClass());
    }
}

