/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.mime;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.util.html.HtmlTextExtractor;

public class MessageContentExtractor {
    public static final String CONTENT_ID = "Content-ID";
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";

    public MessageContent extract(Message message) throws IOException {
        Body body = message.getBody();
        if (body instanceof TextBody) {
            return this.parseTextBody((Entity)message, (TextBody)body);
        }
        if (body instanceof Multipart) {
            return this.parseMultipart((Entity)message, (Multipart)body);
        }
        return MessageContent.empty();
    }

    private MessageContent parseTextBody(Entity entity, TextBody textBody) throws IOException {
        Optional<String> bodyContent = this.asString(textBody);
        if (TEXT_HTML.equals(entity.getMimeType())) {
            return MessageContent.ofHtmlOnly(bodyContent);
        }
        return MessageContent.ofTextOnly(bodyContent);
    }

    private MessageContent parseMultipart(Entity entity, Multipart multipart) throws IOException {
        MessageContent messageContent = this.parseMultipartContent(entity, multipart);
        if (!messageContent.isEmpty()) {
            return messageContent;
        }
        return this.parseFirstFoundMultipart(multipart);
    }

    private MessageContent parseMultipartContent(Entity entity, Multipart multipart) throws IOException {
        switch (entity.getMimeType()) {
            case "multipart/alternative": {
                return this.retrieveHtmlAndPlainTextContent(multipart);
            }
        }
        return this.retrieveFirstReadablePart(multipart);
    }

    private MessageContent parseFirstFoundMultipart(Multipart multipart) throws IOException {
        ThrowingFunction parseMultipart = firstPart -> this.parseMultipart((Entity)firstPart, (Multipart)firstPart.getBody());
        return multipart.getBodyParts().stream().filter(part -> part.getBody() instanceof Multipart).findFirst().map(Throwing.function((ThrowingFunction)parseMultipart).sneakyThrow()).orElse(MessageContent.empty());
    }

    private Optional<String> asString(TextBody textBody) throws IOException {
        return Optional.ofNullable(IOUtils.toString((InputStream)textBody.getInputStream(), (Charset)this.charset(Optional.ofNullable(textBody.getMimeCharset()))));
    }

    private Charset charset(Optional<String> charset) {
        return charset.map(Charset::forName).orElse(Charsets.DEFAULT_CHARSET);
    }

    private MessageContent retrieveHtmlAndPlainTextContent(Multipart multipart) throws IOException {
        Optional<String> htmlBody;
        Optional<String> textBody = this.getFirstMatchingTextBody(multipart, TEXT_PLAIN);
        MessageContent directChildTextBodies = new MessageContent(textBody, htmlBody = this.getFirstMatchingTextBody(multipart, TEXT_HTML));
        if (!directChildTextBodies.isComplete()) {
            MessageContent fromInnerMultipart = this.parseFirstFoundMultipart(multipart);
            return directChildTextBodies.merge(fromInnerMultipart);
        }
        return directChildTextBodies;
    }

    private MessageContent retrieveFirstReadablePart(Multipart multipart) throws IOException {
        return this.retrieveFirstReadablePartMatching(multipart, this::isNotAttachment).orElseGet(() -> this.retrieveFirstReadablePartMatching(multipart, this::isInlinedWithoutCid).orElse(MessageContent.empty()));
    }

    private Optional<MessageContent> retrieveFirstReadablePartMatching(Multipart multipart, Predicate<Entity> predicate) {
        return multipart.getBodyParts().stream().filter(predicate).flatMap(Throwing.function(this::extractContentIfReadable).sneakyThrow()).findFirst();
    }

    private Stream<MessageContent> extractContentIfReadable(Entity entity) throws IOException {
        MessageContent innerMultipartContent;
        if (TEXT_HTML.equals(entity.getMimeType()) && entity.getBody() instanceof TextBody) {
            return Stream.of(MessageContent.ofHtmlOnly(this.asString((TextBody)entity.getBody())));
        }
        if (TEXT_PLAIN.equals(entity.getMimeType()) && entity.getBody() instanceof TextBody) {
            return Stream.of(MessageContent.ofTextOnly(this.asString((TextBody)entity.getBody())));
        }
        if (entity.isMultipart() && entity.getBody() instanceof Multipart && !(innerMultipartContent = this.parseMultipart(entity, (Multipart)entity.getBody())).isEmpty()) {
            return Stream.of(innerMultipartContent);
        }
        return Stream.empty();
    }

    private Optional<String> getFirstMatchingTextBody(Multipart multipart, String mimeType) throws IOException {
        Optional<String> firstMatchingTextBody = this.getFirstMatchingTextBody(multipart, mimeType, this::isNotAttachment);
        if (firstMatchingTextBody.isPresent()) {
            return firstMatchingTextBody;
        }
        Optional<String> fallBackInlinedBodyWithoutCid = this.getFirstMatchingTextBody(multipart, mimeType, this::isInlinedWithoutCid);
        return fallBackInlinedBodyWithoutCid;
    }

    private Optional<String> getFirstMatchingTextBody(Multipart multipart, String mimeType, Predicate<Entity> condition) {
        Function textBodyOptionalFunction = Throwing.function(this::asString).sneakyThrow();
        return multipart.getBodyParts().stream().filter(part -> mimeType.equals(part.getMimeType())).filter(condition).map(Entity::getBody).filter(TextBody.class::isInstance).map(TextBody.class::cast).findFirst().flatMap(textBodyOptionalFunction);
    }

    private boolean isNotAttachment(Entity part) {
        return part.getDispositionType() == null;
    }

    private boolean isInlinedWithoutCid(Entity part) {
        return Objects.equals(part.getDispositionType(), "inline") && part.getHeader().getField(CONTENT_ID) == null;
    }

    public static final class MessageContent {
        private final Optional<String> textBody;
        private final Optional<String> htmlBody;

        public MessageContent(Optional<String> textBody, Optional<String> htmlBody) {
            this.textBody = textBody;
            this.htmlBody = htmlBody;
        }

        public static MessageContent ofTextOnly(Optional<String> textBody) {
            return new MessageContent(textBody, Optional.empty());
        }

        public static MessageContent ofHtmlOnly(Optional<String> htmlBody) {
            return new MessageContent(Optional.empty(), htmlBody);
        }

        public static MessageContent empty() {
            return new MessageContent(Optional.empty(), Optional.empty());
        }

        public Optional<String> getTextBody() {
            return this.textBody;
        }

        public Optional<String> getHtmlBody() {
            return this.htmlBody;
        }

        public boolean isEmpty() {
            return this.equals(MessageContent.empty());
        }

        public boolean isComplete() {
            return this.textBody.isPresent() && this.htmlBody.isPresent();
        }

        public MessageContent merge(MessageContent fromInnerMultipart) {
            return new MessageContent(this.textBody.map(Optional::of).orElse(fromInnerMultipart.getTextBody()), this.htmlBody.map(Optional::of).orElse(fromInnerMultipart.getHtmlBody()));
        }

        public Optional<String> extractMainTextContent(HtmlTextExtractor htmlTextExtractor) {
            return this.htmlBody.map(htmlTextExtractor::toPlainText).filter(Predicate.not(Strings::isNullOrEmpty)).or(() -> this.textBody);
        }

        public int hashCode() {
            return Objects.hash(this.textBody, this.htmlBody);
        }

        public boolean equals(Object other) {
            if (!(other instanceof MessageContent)) {
                return false;
            }
            MessageContent otherMessageContent = (MessageContent)other;
            return Objects.equals(this.textBody, otherMessageContent.textBody) && Objects.equals(this.htmlBody, otherMessageContent.htmlBody);
        }
    }
}

