/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class HostIsLocal
extends GenericMatcher {
    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return (Collection)this.recipientsByDomains(mail).flatMap(this::hasLocalDomain).collect(Guavate.toImmutableList());
    }

    private Stream<MailAddress> hasLocalDomain(Map.Entry<Domain, Collection<MailAddress>> entry) {
        if (this.getMailetContext().isLocalServer(entry.getKey())) {
            return entry.getValue().stream();
        }
        return Stream.empty();
    }

    private Stream<Map.Entry<Domain, Collection<MailAddress>>> recipientsByDomains(Mail mail) {
        return ((ImmutableListMultimap)mail.getRecipients().stream().collect(Guavate.toImmutableListMultimap(MailAddress::getDomain))).asMap().entrySet().stream();
    }
}

