/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpForwardAttribute
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpForwardAttribute.class);
    public static final String URI_PARAMETER_NAME = "uri";
    public static final String EXCHANGE_PARAMETER_NAME = "exchange";
    public static final String ROUTING_KEY_PARAMETER_NAME = "routing_key";
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    public static final String ROUTING_KEY_DEFAULT_VALUE = "";
    private String exchange;
    private AttributeName attribute;
    private ConnectionFactory connectionFactory;
    @VisibleForTesting
    String routingKey;

    public void init() throws MailetException {
        String uri = this.getInitParameter(URI_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)uri)) {
            throw new MailetException("No value for uri parameter was provided.");
        }
        this.exchange = this.getInitParameter(EXCHANGE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)this.exchange)) {
            throw new MailetException("No value for exchange parameter was provided.");
        }
        this.routingKey = this.getInitParameter(ROUTING_KEY_PARAMETER_NAME, ROUTING_KEY_DEFAULT_VALUE);
        String rawAttribute = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)rawAttribute)) {
            throw new MailetException("No value for attribute parameter was provided.");
        }
        this.attribute = AttributeName.of((String)rawAttribute);
        this.connectionFactory = new ConnectionFactory();
        try {
            this.connectionFactory.setUri(uri);
        }
        catch (Exception e) {
            throw new MailetException("Invalid uri parameter was provided: " + uri, e);
        }
    }

    @VisibleForTesting
    void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void service(Mail mail) throws MailetException {
        mail.getAttribute(this.attribute).map(Throwing.function(this::getAttributeContent).sneakyThrow()).ifPresent(this::sendContent);
    }

    private Stream<byte[]> getAttributeContent(Attribute attribute) throws MailetException {
        return this.extractAttributeValueContent(attribute.getValue().value()).orElseThrow(() -> new MailetException("Invalid attribute found into attribute " + this.attribute.asString() + "class Map or List or String expected but " + attribute.toString() + " found."));
    }

    private Optional<Stream<byte[]>> extractAttributeValueContent(Object attributeContent) {
        if (attributeContent instanceof Map) {
            return Optional.of(((Map)attributeContent).values().stream());
        }
        if (attributeContent instanceof List) {
            return Optional.of(((List)attributeContent).stream().map(AttributeValue::value));
        }
        if (attributeContent instanceof String) {
            return Optional.of(Stream.of(((String)attributeContent).getBytes(StandardCharsets.UTF_8)));
        }
        return Optional.empty();
    }

    private void sendContent(Stream<byte[]> content) {
        try {
            this.trySendContent(content);
        }
        catch (IOException e) {
            LOGGER.error("IOException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (TimeoutException e) {
            LOGGER.error("TimeoutException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (AlreadyClosedException e) {
            LOGGER.error("AlreadyClosedException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void trySendContent(Stream<byte[]> content) throws IOException, TimeoutException {
        try (Connection connection = this.connectionFactory.newConnection();
             Channel channel = connection.createChannel();){
            channel.exchangeDeclarePassive(this.exchange);
            this.sendContentOnChannel(channel, content);
        }
    }

    private void sendContentOnChannel(Channel channel, Stream<byte[]> content) throws IOException {
        content.forEach((Consumer<byte[]>)Throwing.consumer(message -> channel.basicPublish(this.exchange, this.routingKey, new AMQP.BasicProperties(), message)));
    }

    public String getMailetInfo() {
        return "AmqpForwardAttribute";
    }
}

