/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.message.BytesBackedLiteral;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.utils.EolInputStream;

public class ImapRequestStreamLineReader
extends ImapRequestLineReader
implements Closeable {
    private final InputStream input;
    private final OutputStream output;

    public ImapRequestStreamLineReader(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            int next = -1;
            try {
                next = this.input.read();
            }
            catch (IOException e) {
                throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error reading from stream.", e);
            }
            if (next == -1) {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected end of stream.");
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    @Override
    public Literal read(int size, boolean extraCRLF) throws IOException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        InputStream limited = ByteStreams.limit((InputStream)this.input, (long)size);
        if (extraCRLF) {
            return BytesBackedLiteral.copy(new EolInputStream(this, limited));
        }
        return BytesBackedLiteral.copy(limited);
    }

    @Override
    protected void commandContinuationRequest() throws DecodingException {
        try {
            this.output.write(43);
            this.output.write(13);
            this.output.write(10);
            this.output.flush();
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Unexpected exception in sending command continuation request.", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.input.close();
        }
        finally {
            this.output.close();
        }
    }
}

