/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxSetError$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.RemoveEmailsOnDestroy;
import org.apache.james.jmap.method.MailboxHasChildException;
import org.apache.james.jmap.method.MailboxHasMailException;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$MailboxDeletionResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r=t!B+W\u0011\u0003\tg!B2W\u0011\u0003!\u0007\"B6\u0002\t\u0003agaB7\u0002!\u0003\r\nC\u001c\u0004\u0007\u00033\f\u0001)a7\t\u0015\u0005\u001dAA!f\u0001\n\u0003\ti\u000e\u0003\u0006\u00022\u0011\u0011\t\u0012)A\u0005\u0003?Daa\u001b\u0003\u0005\u0002\u0005=\b\"CA,\t\u0005\u0005I\u0011AA{\u0011%\ty\u0006BI\u0001\n\u0003\tI\u0010C\u0005\u0002~\u0011\t\t\u0011\"\u0011\u0002\u0000!I\u0011\u0011\u0013\u0003\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u00037#\u0011\u0011!C\u0001\u0003{D\u0011\"!+\u0005\u0003\u0003%\t%a+\t\u0013\u0005eF!!A\u0005\u0002\t\u0005\u0001\"CAc\t\u0005\u0005I\u0011\tB\u0003\u0011%\tY\rBA\u0001\n\u0003\ni\rC\u0005\u0002P\u0012\t\t\u0011\"\u0011\u0002R\"I\u00111\u001b\u0003\u0002\u0002\u0013\u0005#\u0011B\u0004\n\u0005\u001b\t\u0011\u0011!E\u0001\u0005\u001f1\u0011\"!7\u0002\u0003\u0003E\tA!\u0005\t\r-$B\u0011\u0001B\u0015\u0011%\ty\rFA\u0001\n\u000b\n\t\u000eC\u0005\u0003,Q\t\t\u0011\"!\u0003.!I!\u0011\u0007\u000b\u0002\u0002\u0013\u0005%1\u0007\u0005\n\u0005\u007f!\u0012\u0011!C\u0005\u0005\u00032A\u0001]\u0001Ac\"Q\u0011q\u0001\u000e\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005E\"D!E!\u0002\u0013\tY\u0001\u0003\u0006\u00024i\u0011)\u001a!C\u0001\u0003kA!\"!\u0010\u001b\u0005#\u0005\u000b\u0011BA\u001c\u0011\u0019Y'\u0004\"\u0001\u0002@!9\u0011q\t\u000e\u0005\u0002\u0005%\u0003\"CA,5\u0005\u0005I\u0011AA-\u0011%\tyFGI\u0001\n\u0003\t\t\u0007C\u0005\u0002xi\t\n\u0011\"\u0001\u0002z!I\u0011Q\u0010\u000e\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\n\u0003#S\u0012\u0011!C\u0001\u0003'C\u0011\"a'\u001b\u0003\u0003%\t!!(\t\u0013\u0005%&$!A\u0005B\u0005-\u0006\"CA]5\u0005\u0005I\u0011AA^\u0011%\t)MGA\u0001\n\u0003\n9\rC\u0005\u0002Lj\t\t\u0011\"\u0011\u0002N\"I\u0011q\u001a\u000e\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003'T\u0012\u0011!C!\u0003+<\u0011B!\u0013\u0002\u0003\u0003E\tAa\u0013\u0007\u0011A\f\u0011\u0011!E\u0001\u0005\u001bBaa\u001b\u0018\u0005\u0002\tU\u0003\"CAh]\u0005\u0005IQIAi\u0011%\u0011YCLA\u0001\n\u0003\u00139\u0006C\u0005\u000329\n\t\u0011\"!\u0003^!I!q\b\u0018\u0002\u0002\u0013%!\u0011\t\u0004\u0007\u0005S\n\u0001Ia\u001b\t\u0015\t5DG!f\u0001\n\u0003\u0011y\u0007\u0003\u0006\u0003xQ\u0012\t\u0012)A\u0005\u0005cBaa\u001b\u001b\u0005\u0002\te\u0004b\u0002B@i\u0011\u0005!\u0011\u0011\u0005\b\u0005\u000b#D\u0011\u0001BD\u0011%\t9\u0006NA\u0001\n\u0003\u0011I\nC\u0005\u0002`Q\n\n\u0011\"\u0001\u0003\u001e\"I\u0011Q\u0010\u001b\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\n\u0003##\u0014\u0011!C\u0001\u0003'C\u0011\"a'5\u0003\u0003%\tA!)\t\u0013\u0005%F'!A\u0005B\u0005-\u0006\"CA]i\u0005\u0005I\u0011\u0001BS\u0011%\t)\rNA\u0001\n\u0003\u0012I\u000bC\u0005\u0002LR\n\t\u0011\"\u0011\u0002N\"I\u0011q\u001a\u001b\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003'$\u0014\u0011!C!\u0005[;\u0011B!-\u0002\u0003\u0003E\tAa-\u0007\u0013\t%\u0014!!A\t\u0002\tU\u0006BB6G\t\u0003\u0011I\fC\u0005\u0002P\u001a\u000b\t\u0011\"\u0012\u0002R\"I!1\u0006$\u0002\u0002\u0013\u0005%1\u0018\u0005\n\u0005c1\u0015\u0011!CA\u0005\u007fC\u0011Ba\u0010G\u0003\u0003%IA!\u0011\u0007\u000b\r4\u0006A!2\t\u0015\t\u001dGJ!A!\u0002\u0013\u0011I\r\u0003\u0006\u0003R2\u0013\t\u0011)A\u0005\u0005'D!B!7M\u0005\u0003\u0005\u000b\u0011\u0002Bn\u0011\u0019YG\n\"\u0001\u0003j\"91Q\u0001'\u0005\u0002\r\u001d\u0001bBB\u001e\u0019\u0012%1Q\b\u0005\b\u0007'bE\u0011BB+\u0011\u001d\u0019\u0019\u0007\u0014C\u0005\u0007K\n\u0011$T1jY\n|\u0007pU3u\t\u0016dW\r^3QKJ4wN]7fe*\u0011q\u000bW\u0001\u0007[\u0016$\bn\u001c3\u000b\u0005eS\u0016\u0001\u00026nCBT!a\u0017/\u0002\u000b)\fW.Z:\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0002\u0001!\t\u0011\u0017!D\u0001W\u0005ei\u0015-\u001b7c_b\u001cV\r\u001e#fY\u0016$X\rU3sM>\u0014X.\u001a:\u0014\u0005\u0005)\u0007C\u00014j\u001b\u00059'\"\u00015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)<'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\n)R*Y5mE>DH)\u001a7fi&|gNU3tk2$8CA\u0002fS\r\u0019!\u0004\u0002\u0002\u0017\u001b\u0006LGNY8y\t\u0016dW\r^5p]\u001a\u000b\u0017\u000e\\;sKN)!$\u001a:uoB\u00111oA\u0007\u0002\u0003A\u0011a-^\u0005\u0003m\u001e\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002y\u0003\u0003q!!\u001f@\u000f\u0005ilX\"A>\u000b\u0005q\u0004\u0017A\u0002\u001fs_>$h(C\u0001i\u0013\tyx-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u007f\u001e\f\u0011\"\\1jY\n|\u00070\u00133\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003WqA!a\u0004\u0002&9!\u0011\u0011CA\u0011\u001d\u0011\t\u0019\"a\b\u000f\t\u0005U\u0011Q\u0004\b\u0005\u0003/\tYBD\u0002{\u00033I\u0011aX\u0005\u0003;zK!a\u0017/\n\u0005eS\u0016bAA\u00121\u0006!Q.Y5m\u0013\u0011\t9#!\u000b\u0002\u00155\u000b\u0017\u000e\u001c2pq\u001e+GOC\u0002\u0002$aKA!!\f\u00020\t\tRK\u001c9beN,G-T1jY\n|\u00070\u00133\u000b\t\u0005\u001d\u0012\u0011F\u0001\u000b[\u0006LGNY8y\u0013\u0012\u0004\u0013!C3yG\u0016\u0004H/[8o+\t\t9\u0004E\u0002y\u0003sIA!a\u000f\u0002\u0006\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u000bKb\u001cW\r\u001d;j_:\u0004CCBA!\u0003\u0007\n)\u0005\u0005\u0002t5!9\u0011qA\u0010A\u0002\u0005-\u0001bBA\u001a?\u0001\u0007\u0011qG\u0001\u0012CNl\u0015-\u001b7c_b\u001cV\r^#se>\u0014XCAA&!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)1\u0006!1m\u001c:f\u0013\u0011\t)&a\u0014\u0003\u0011M+G/\u0012:s_J\fAaY8qsR1\u0011\u0011IA.\u0003;B\u0011\"a\u0002\"!\u0003\u0005\r!a\u0003\t\u0013\u0005M\u0012\u0005%AA\u0002\u0005]\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GRC!a\u0003\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002r\u001d\f!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m$\u0006BA\u001c\u0003K\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000bA\u0001\\1oO*\u0011\u00111R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0006\u0015%AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016B\u0019a-a&\n\u0007\u0005euMA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002 \u0006\u0015\u0006c\u00014\u0002\"&\u0019\u00111U4\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002(\u001a\n\t\u00111\u0001\u0002\u0016\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!,\u0011\r\u0005=\u0016QWAP\u001b\t\t\tLC\u0002\u00024\u001e\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9,!-\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\u000b\u0019\rE\u0002g\u0003\u007fK1!!1h\u0005\u001d\u0011un\u001c7fC:D\u0011\"a*)\u0003\u0003\u0005\r!a(\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0003\u000bI\rC\u0005\u0002(&\n\t\u00111\u0001\u0002\u0016\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0002\u00061Q-];bYN$B!!0\u0002X\"I\u0011q\u0015\u0017\u0002\u0002\u0003\u0007\u0011q\u0014\u0002\u0017\u001b\u0006LGNY8y\t\u0016dW\r^5p]N+8mY3tgN)A!\u001a:uoV\u0011\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u0015iw\u000eZ3m\u0015\r\tIOW\u0001\b[\u0006LGNY8y\u0013\u0011\ti/a9\u0003\u00135\u000b\u0017\u000e\u001c2pq&#G\u0003BAy\u0003g\u0004\"a\u001d\u0003\t\u000f\u0005\u001dq\u00011\u0001\u0002`R!\u0011\u0011_A|\u0011%\t9\u0001\u0003I\u0001\u0002\u0004\ty.\u0006\u0002\u0002|*\"\u0011q\\A3)\u0011\ty*a@\t\u0013\u0005\u001dF\"!AA\u0002\u0005UE\u0003BA_\u0005\u0007A\u0011\"a*\u000f\u0003\u0003\u0005\r!a(\u0015\t\u0005\u0005%q\u0001\u0005\n\u0003O{\u0011\u0011!a\u0001\u0003+#B!!0\u0003\f!I\u0011q\u0015\n\u0002\u0002\u0003\u0007\u0011qT\u0001\u0017\u001b\u0006LGNY8y\t\u0016dW\r^5p]N+8mY3tgB\u00111\u000fF\n\u0006)\tM!q\u0004\t\t\u0005+\u0011Y\"a8\u0002r6\u0011!q\u0003\u0006\u0004\u000539\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005;\u00119BA\tBEN$(/Y2u\rVt7\r^5p]F\u0002BA!\t\u0003(5\u0011!1\u0005\u0006\u0005\u0005K\tI)\u0001\u0002j_&!\u00111\u0001B\u0012)\t\u0011y!A\u0003baBd\u0017\u0010\u0006\u0003\u0002r\n=\u0002bBA\u0004/\u0001\u0007\u0011q\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)Da\u000f\u0011\u000b\u0019\u00149$a8\n\u0007\terM\u0001\u0004PaRLwN\u001c\u0005\n\u0005{A\u0012\u0011!a\u0001\u0003c\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0005\u0005\u0003\u0002\u0004\n\u0015\u0013\u0002\u0002B$\u0003\u000b\u0013aa\u00142kK\u000e$\u0018AF'bS2\u0014w\u000e\u001f#fY\u0016$\u0018n\u001c8GC&dWO]3\u0011\u0005Mt3#\u0002\u0018\u0003P\t}\u0001C\u0003B\u000b\u0005#\nY!a\u000e\u0002B%!!1\u000bB\f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005\u0017\"b!!\u0011\u0003Z\tm\u0003bBA\u0004c\u0001\u0007\u00111\u0002\u0005\b\u0003g\t\u0004\u0019AA\u001c)\u0011\u0011yFa\u001a\u0011\u000b\u0019\u00149D!\u0019\u0011\u000f\u0019\u0014\u0019'a\u0003\u00028%\u0019!QM4\u0003\rQ+\b\u000f\\33\u0011%\u0011iDMA\u0001\u0002\u0004\t\tE\u0001\fNC&d'm\u001c=EK2,G/[8o%\u0016\u001cX\u000f\u001c;t'\u0011!T\r^<\u0002\u000fI,7/\u001e7ugV\u0011!\u0011\u000f\t\u0005q\nM$/\u0003\u0003\u0003v\u0005\u0015!aA*fc\u0006A!/Z:vYR\u001c\b\u0005\u0006\u0003\u0003|\tu\u0004CA:5\u0011\u001d\u0011ig\u000ea\u0001\u0005c\n\u0011\u0002Z3tiJ|\u00170\u001a3\u0016\u0005\t\r\u0005#\u0002=\u0003t\u0005}\u0017A\u0004:fiJLWM^3FeJ|'o]\u000b\u0003\u0005\u0013\u0003\u0002Ba#\u0003\u0014\u0006-\u00111\n\b\u0005\u0005\u001b\u0013y\t\u0005\u0002{O&\u0019!\u0011S4\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Ja&\u0003\u00075\u000b\u0007OC\u0002\u0003\u0012\u001e$BAa\u001f\u0003\u001c\"I!Q\u000e\u001e\u0011\u0002\u0003\u0007!\u0011O\u000b\u0003\u0005?SCA!\u001d\u0002fQ!\u0011q\u0014BR\u0011%\t9KPA\u0001\u0002\u0004\t)\n\u0006\u0003\u0002>\n\u001d\u0006\"CAT\u0001\u0006\u0005\t\u0019AAP)\u0011\t\tIa+\t\u0013\u0005\u001d\u0016)!AA\u0002\u0005UE\u0003BA_\u0005_C\u0011\"a*E\u0003\u0003\u0005\r!a(\u0002-5\u000b\u0017\u000e\u001c2pq\u0012+G.\u001a;j_:\u0014Vm];miN\u0004\"a\u001d$\u0014\u000b\u0019\u00139La\b\u0011\u0011\tU!1\u0004B9\u0005w\"\"Aa-\u0015\t\tm$Q\u0018\u0005\b\u0005[J\u0005\u0019\u0001B9)\u0011\u0011\tMa1\u0011\u000b\u0019\u00149D!\u001d\t\u0013\tu\"*!AA\u0002\tm4C\u0001'f\u00039i\u0017-\u001b7c_bl\u0015M\\1hKJ\u0004BAa3\u0003N6\u0011\u0011q]\u0005\u0005\u0005\u001f\f9O\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002'M,(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0011\t\t-'Q[\u0005\u0005\u0005/\f9OA\nTk\n\u001c8M]5qi&|g.T1oC\u001e,'/\u0001\tnC&d'm\u001c=JI\u001a\u000b7\r^8ssB!!Q\u001cBr\u001d\u0011\t\tOa8\n\t\t\u0005\u00181]\u0001\n\u001b\u0006LGNY8y\u0013\u0012LAA!:\u0003h\n9a)Y2u_JL(\u0002\u0002Bq\u0003G$\u0002Ba;\u0003n\n=(\u0011\u001f\t\u0003E2CqAa2Q\u0001\u0004\u0011I\rC\u0004\u0003RB\u0003\rAa5\t\u000f\te\u0007\u000b1\u0001\u0003\\\"\u001a\u0001K!>\u0011\t\t]8\u0011A\u0007\u0003\u0005sTAAa?\u0003~\u00061\u0011N\u001c6fGRT!Aa@\u0002\u000b)\fg/\u0019=\n\t\r\r!\u0011 \u0002\u0007\u0013:TWm\u0019;\u0002\u001f\u0011,G.\u001a;f\u001b\u0006LGNY8yKN$ba!\u0003\u0004&\r=\u0002CBB\u0006\u00073\u0019i\"\u0004\u0002\u0004\u000e)!1qBB\t\u0003%\u0001XO\u00197jg\",'OC\u0002i\u0007'QA!!\u0015\u0004\u0016)\u00111qC\u0001\be\u0016\f7\r^8s\u0013\u0011\u0019Yb!\u0004\u0003\u000bMkuN\\8\u0011\u0007\r}AGD\u0002\u0004\"\u0001qA!!\u0005\u0004$%\u0011q\u000b\u0017\u0005\b\u0007O\t\u0006\u0019AB\u0015\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004BAa3\u0004,%!1QFAt\u00059i\u0015-\u001b7c_b\u001cVm]:j_:Dqa!\rR\u0001\u0004\u0019\u0019$A\tnC&d'm\u001c=TKR\u0014V-];fgR\u0004Ba!\u000e\u000485\u0011\u0011\u0011F\u0005\u0005\u0007s\tICA\tNC&d'm\u001c=TKR\u0014V-];fgR\fa\u0001Z3mKR,G\u0003CB \u0007\u0007\u001a)e!\u0013\u0011\r\r-1\u0011DB!!\r\u0019yb\u0001\u0005\b\u0007O\u0011\u0006\u0019AB\u0015\u0011\u001d\u00199E\u0015a\u0001\u0003\u0017\t!!\u001b3\t\u000f\r-#\u000b1\u0001\u0004N\u0005IqN\u001c#fgR\u0014x.\u001f\t\u0005\u0007k\u0019y%\u0003\u0003\u0004R\u0005%\"!\u0006*f[>4X-R7bS2\u001cxJ\u001c#fgR\u0014x._\u0001\tI>$U\r\\3uKRA1qKB/\u0007?\u001a\t\u0007E\u0002g\u00073J1aa\u0017h\u0005\u0011)f.\u001b;\t\u000f\r\u001d2\u000b1\u0001\u0004*!91qI*A\u0002\u0005}\u0007bBB&'\u0002\u00071QJ\u0001\u0011SN\f5+_:uK6l\u0015-\u001b7c_b$B!!0\u0004h!9\u0011\u0011\u001e+A\u0002\r%\u0004\u0003\u0002Bf\u0007WJAa!\u001c\u0002h\nqQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\b")
public class MailboxSetDeletePerformer {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxDeletionResults> deleteMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.destroy().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> MailboxSetDeletePerformer.$anonfun$deleteMailboxes$2(this, mailboxSession, mailboxSetRequest, (String)((Refined)id).value());
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetDeletePerformer$MailboxDeletionResults$.MODULE$);
    }

    private SMono<MailboxDeletionResult> delete(MailboxSession mailboxSession, String id2, boolean onDestroy) {
        return (SMono)MailboxGet$.MODULE$.parse(this.mailboxIdFactory, id2).fold((Function1 & Serializable)e -> SMono$.MODULE$.raiseError(e), (Function1 & Serializable)id -> SMono$.MODULE$.fromCallable(() -> {
            this.doDelete(mailboxSession, id, onDestroy);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).then(SMono$.MODULE$.just((Object)new MailboxDeletionSuccess((MailboxId)id))));
    }

    private void doDelete(MailboxSession mailboxSession, MailboxId id, boolean onDestroy) {
        MessageManager mailbox = this.mailboxManager.getMailbox(id, mailboxSession);
        if (this.isASystemMailbox(mailbox)) {
            throw new SystemMailboxChangeException(id);
        }
        if (this.mailboxManager.hasChildren(mailbox.getMailboxPath(), mailboxSession)) {
            throw new MailboxHasChildException(id);
        }
        if (onDestroy) {
            Mailbox deletedMailbox = this.mailboxManager.deleteMailbox(id, mailboxSession);
            this.subscriptionManager.unsubscribe(mailboxSession, deletedMailbox.getName());
        } else {
            if (mailbox.getMessages(MessageRange.all(), FetchGroup.MINIMAL, mailboxSession).hasNext()) {
                throw new MailboxHasMailException(id);
            }
            Mailbox deletedMailbox = this.mailboxManager.deleteMailbox(id, mailboxSession);
            this.subscriptionManager.unsubscribe(mailboxSession, deletedMailbox.getName());
        }
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteMailboxes$3() {
        return false;
    }

    public static final /* synthetic */ SMono $anonfun$deleteMailboxes$2(MailboxSetDeletePerformer $this, MailboxSession mailboxSession$1, MailboxSetRequest mailboxSetRequest$1, String id) {
        return $this.delete(mailboxSession$1, id, ((RemoveEmailsOnDestroy)mailboxSetRequest$1.onDestroyRemoveEmails().getOrElse((Function0 & Serializable)() -> new RemoveEmailsOnDestroy(MailboxSetDeletePerformer.$anonfun$deleteMailboxes$3()))).value()).onErrorRecover((PartialFunction)new Serializable(null, id){
            private static final long serialVersionUID = 0L;
            private final String id$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                MailboxDeletionFailure mailboxDeletionFailure = new MailboxDeletionFailure(this.id$1, e);
                return (B1)mailboxDeletionFailure;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                boolean bl = true;
                return bl;
            }
            {
                this.id$1 = id$1;
            }
        });
    }

    @Inject
    public MailboxSetDeletePerformer(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxDeletionFailure
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final String mailboxId;
        private final Throwable exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            SetError setError;
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            } else if (throwable instanceof MailboxHasMailException) {
                MailboxHasMailException mailboxHasMailException = (MailboxHasMailException)throwable;
                setError = MailboxSetError$.MODULE$.mailboxHasEmail(new StringBuilder(13).append(mailboxHasMailException.mailboxId().serialize()).append(" is not empty").toString());
            } else if (throwable instanceof MailboxHasChildException) {
                MailboxHasChildException mailboxHasChildException = (MailboxHasChildException)throwable;
                setError = MailboxSetError$.MODULE$.mailboxHasChild(new StringBuilder(20).append(mailboxHasChildException.mailboxId().serialize()).append(" has child mailboxes").toString());
            } else if (throwable instanceof SystemMailboxChangeException) {
                setError = SetError$.MODULE$.invalidArguments("System mailboxes cannot be destroyed", SetError$.MODULE$.invalidArguments$default$2());
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidArguments(new StringBuilder(21).append(new Refined((Object)this.mailboxId())).append(" is not a mailboxId: ").append(illegalArgumentException.getMessage()).toString(), SetError$.MODULE$.invalidArguments$default$2());
            } else {
                setError = SetError$.MODULE$.serverFail(this.exception().getMessage());
            }
            return setError;
        }

        public MailboxDeletionFailure copy(String mailboxId, Throwable exception) {
            return new MailboxDeletionFailure(mailboxId, exception);
        }

        public String copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxDeletionFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new Refined((Object)this.mailboxId());
                    break;
                }
                case 1: {
                    object = this.exception();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                case 1: {
                    string2 = "exception";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)x$1;
            Refined refined = new Refined((Object)this.mailboxId());
            Refined refined2 = new Refined((Object)mailboxDeletionFailure.mailboxId());
            if (refined == null) {
                if (refined2 != null) {
                    return false;
                }
            } else if (!refined.equals(refined2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxDeletionFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!mailboxDeletionFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionFailure(String mailboxId, Throwable exception) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxDeletionResult {
    }

    public static class MailboxDeletionResults
    implements Product,
    Serializable {
        private final Seq<MailboxDeletionResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxDeletionResult> results() {
            return this.results;
        }

        public Seq<MailboxId> destroyed() {
            return (Seq)((IterableOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionSuccess) {
                    MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)mailboxDeletionResult;
                    none$ = new Some((Object)mailboxDeletionSuccess);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).map((Function1 & Serializable)x$1 -> x$1.mailboxId());
        }

        public Map<Refined<String, boolean.Not<collection.Empty>>, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionFailure) {
                    MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)mailboxDeletionResult;
                    none$ = new Some((Object)new Tuple2((Object)new Refined((Object)mailboxDeletionFailure.mailboxId()), (Object)mailboxDeletionFailure.asMailboxSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxDeletionResults copy(Seq<MailboxDeletionResult> results) {
            return new MailboxDeletionResults(results);
        }

        public Seq<MailboxDeletionResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxDeletionResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionResults mailboxDeletionResults = (MailboxDeletionResults)x$1;
            Seq<MailboxDeletionResult> seq = this.results();
            Seq<MailboxDeletionResult> seq2 = mailboxDeletionResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxDeletionResults.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionResults(Seq<MailboxDeletionResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxDeletionSuccess
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxDeletionSuccess copy(MailboxId mailboxId) {
            return new MailboxDeletionSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxDeletionSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxDeletionSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxDeletionSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

