/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.change;

import java.io.Serializable;
import java.time.Clock;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.change.AccountIdRegistrationKey;
import org.apache.james.jmap.change.MailboxChangeListener$;
import org.apache.james.jmap.change.MailboxChangeListenerGroup;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.State;
import org.apache.james.jmap.core.State$;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r-r!\u0002\u00192\u0011\u0003ad!\u0002 2\u0011\u0003y\u0004\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%\t!\u0015\u0005\u00071\u0006\u0001\u000b\u0011\u0002*\t\u000fe\u000b\u0011\u0011!CA5\"I11C\u0001\u0002\u0002\u0013\u00055Q\u0003\u0005\n\u0007O\t\u0011\u0011!C\u0005\u0007S1AAP\u0019A9\"Q\u0011Q\u0001\u0005\u0003\u0016\u0004%\t!a\u0002\t\u0015\u0005E\u0001B!E!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0014!\u0011)\u001a!C\u0001\u0003+A!\"!\n\t\u0005#\u0005\u000b\u0011BA\f\u0011)\t9\u0003\u0003BK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003sA!\u0011#Q\u0001\n\u0005-\u0002BCA\u001e\u0011\tU\r\u0011\"\u0001\u0002>!Q\u0011Q\t\u0005\u0003\u0012\u0003\u0006I!a\u0010\t\u0015\u0005\u001d\u0003B!f\u0001\n\u0003\tI\u0005\u0003\u0006\u0002X!\u0011\t\u0012)A\u0005\u0003\u0017B!\"!\u0017\t\u0005+\u0007I\u0011AA.\u0011)\tI\u0007\u0003B\tB\u0003%\u0011Q\f\u0005\u000b\u0003WB!Q3A\u0005\u0002\u00055\u0004BCA>\u0011\tE\t\u0015!\u0003\u0002p!1a\n\u0003C\u0001\u0003{Bq!!,\t\t\u0003\ny\u000bC\u0004\u0002N\"!\t%a4\t\u000f\u0005]\u0007\u0002\"\u0011\u0002Z\"9\u00111\u001d\u0005\u0005\n\u0005\u0015\bb\u0002B\u0010\u0011\u0011%!\u0011\u0005\u0005\b\u0005[AA\u0011\u0002B\u0018\u0011\u001d\u0011y\u0006\u0003C\u0005\u0005CB\u0011Ba\u001b\t\u0003\u0003%\tA!\u001c\t\u0013\tu\u0004\"%A\u0005\u0002\t}\u0004\"\u0003BK\u0011E\u0005I\u0011\u0001BL\u0011%\u0011Y\nCI\u0001\n\u0003\u0011i\nC\u0005\u0003\"\"\t\n\u0011\"\u0001\u0003$\"I!q\u0015\u0005\u0012\u0002\u0013\u0005!\u0011\u0016\u0005\n\u0005[C\u0011\u0013!C\u0001\u0005_C\u0011Ba-\t#\u0003%\tA!.\t\u0013\te\u0006\"!A\u0005B\tm\u0006\"\u0003Bb\u0011\u0005\u0005I\u0011\u0001Bc\u0011%\u0011i\rCA\u0001\n\u0003\u0011y\rC\u0005\u0003\\\"\t\t\u0011\"\u0011\u0003^\"I!1\u001e\u0005\u0002\u0002\u0013\u0005!Q\u001e\u0005\n\u0005cD\u0011\u0011!C!\u0005gD\u0011Ba>\t\u0003\u0003%\tE!?\t\u0013\tm\b\"!A\u0005B\tu\b\"\u0003B\u0000\u0011\u0005\u0005I\u0011IB\u0001\u0003Ui\u0015-\u001b7c_b\u001c\u0005.\u00198hK2K7\u000f^3oKJT!AM\u001a\u0002\r\rD\u0017M\\4f\u0015\t!T'\u0001\u0003k[\u0006\u0004(B\u0001\u001c8\u0003\u0015Q\u0017-\\3t\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\u0004\u0001A\u0011Q(A\u0007\u0002c\t)R*Y5mE>D8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148cA\u0001A\rB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0005%|'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u001f\u0002\r1{uiR#S+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+:\u0003\u0015\u0019HN\u001a\u001bk\u0013\t9FK\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0003\u0015\t\u0007\u000f\u001d7z)=Y6QAB\u0004\u0007\u0013\u0019Ya!\u0004\u0004\u0010\rE\u0001CA\u001f\t'\u0015AQlY<{!\tq\u0016-D\u0001`\u0015\t\u0001'*\u0001\u0003mC:<\u0017B\u00012`\u0005\u0019y%M[3diB\u0011A\r\u001e\b\u0003KFt!AZ8\u000f\u0005\u001dtgB\u00015n\u001d\tIG.D\u0001k\u0015\tY7(\u0001\u0004=e>|GOP\u0005\u0002u%\u0011\u0001(O\u0005\u0003m]J!\u0001]\u001b\u0002\r\u00154XM\u001c;t\u0013\t\u00118/A\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0006\u0003aVJ!!\u001e<\u00035I+\u0017m\u0019;jm\u0016<%o\\;q\u000bZ,g\u000e\u001e'jgR,g.\u001a:\u000b\u0005I\u001c\bCA!y\u0013\tI(IA\u0004Qe>$Wo\u0019;\u0011\u0007m\f\tA\u0004\u0002}}:\u0011\u0011.`\u0005\u0002\u0007&\u0011qPQ\u0001\ba\u0006\u001c7.Y4f\u0013\ri\u00151\u0001\u0006\u0003\u007f\n\u000b\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u000e5\t1/C\u0002\u0002\u0010M\u0014\u0001\"\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\nq#\\1jY\n|\u0007p\u00115b]\u001e,'+\u001a9pg&$xN]=\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Ci!!a\u0007\u000b\u0007I\niBC\u0002\u0002 M\n1!\u00199j\u0013\u0011\t\u0019#a\u0007\u0003/5\u000b\u0017\u000e\u001c2pq\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018\u0001G7bS2\u0014w\u000e_\"iC:<WMU3q_NLGo\u001c:zA\u0005!R.Y5mE>D8\t[1oO\u00164\u0015m\u0019;pef,\"!a\u000b\u0011\t\u00055\u00121\u0007\b\u0005\u00033\ty#\u0003\u0003\u00022\u0005m\u0011!D'bS2\u0014w\u000e_\"iC:<W-\u0003\u0003\u00026\u0005]\"a\u0002$bGR|'/\u001f\u0006\u0005\u0003c\tY\"A\u000bnC&d'm\u001c=DQ\u0006tw-\u001a$bGR|'/\u001f\u0011\u0002+\u0015l\u0017-\u001b7DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ssV\u0011\u0011q\b\t\u0005\u00033\t\t%\u0003\u0003\u0002D\u0005m!!F#nC&d7\t[1oO\u0016\u0014V\r]8tSR|'/_\u0001\u0017K6\f\u0017\u000e\\\"iC:<WMU3q_NLGo\u001c:zA\u0005\u0011R-\\1jY\u000eC\u0017M\\4f\r\u0006\u001cGo\u001c:z+\t\tY\u0005\u0005\u0003\u0002N\u0005Mc\u0002BA\r\u0003\u001fJA!!\u0015\u0002\u001c\u0005YQ)\\1jY\u000eC\u0017M\\4f\u0013\u0011\t)$!\u0016\u000b\t\u0005E\u00131D\u0001\u0014K6\f\u0017\u000e\\\"iC:<WMR1di>\u0014\u0018\u0010I\u0001\u000f[\u0006LGNY8y\u001b\u0006t\u0017mZ3s+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019'N\u0001\b[\u0006LGNY8y\u0013\u0011\t9'!\u0019\u0003\u001d5\u000b\u0017\u000e\u001c2pq6\u000bg.Y4fe\u0006yQ.Y5mE>DX*\u00198bO\u0016\u0014\b%A\u0003dY>\u001c7.\u0006\u0002\u0002pA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002v)\u000bA\u0001^5nK&!\u0011\u0011PA:\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lAQy1,a \u0002\u001a\u0006m\u0015QTAP\u0003C\u000b\u0019\u000bC\u0004\u0002\u0006]\u0001\r!!\u0003)\u0011\u0005}\u00141QAJ\u0003+\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003\u001b\u000bQA[1wCbLA!!%\u0002\b\n)a*Y7fI\u0006)a/\u00197vK\u0006\u0012\u0011qS\u0001\u0005\u00156\u000b\u0005\u000bC\u0004\u0002\u0014]\u0001\r!a\u0006\t\u000f\u0005\u001dr\u00031\u0001\u0002,!9\u00111H\fA\u0002\u0005}\u0002bBA$/\u0001\u0007\u00111\n\u0005\b\u00033:\u0002\u0019AA/\u0011\u001d\tYg\u0006a\u0001\u0003_B3aFAT!\u0011\t))!+\n\t\u0005-\u0016q\u0011\u0002\u0007\u0013:TWm\u0019;\u0002\u001bI,\u0017m\u0019;jm\u0016,e/\u001a8u)\u0011\t\t,a1\u0011\r\u0005M\u0016\u0011XA_\u001b\t\t)LC\u0002\u00028f\nqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0005\u0003w\u000b)LA\u0005Qk\nd\u0017n\u001d5feB\u0019a,a0\n\u0007\u0005\u0005wL\u0001\u0003W_&$\u0007bBAc1\u0001\u0007\u0011qY\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003\u0017\tI-C\u0002\u0002LN\u0014Q!\u0012<f]R\fqbZ3u\t\u00164\u0017-\u001e7u\u000fJ|W\u000f\u001d\u000b\u0003\u0003#\u0004B!a\u0003\u0002T&\u0019\u0011Q[:\u0003\u000b\u001d\u0013x.\u001e9\u0002\u0015%\u001c\b*\u00198eY&tw\r\u0006\u0003\u0002\\\u0006\u0005\bcA!\u0002^&\u0019\u0011q\u001c\"\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0019\u000eA\u0002\u0005\u001d\u0017a\u00035b]\u0012dW-\u0012<f]R$B!a:\u0003\u0004A1\u0011\u0011^A}\u0003{l!!a;\u000b\t\u00055\u0018q^\u0001\naV\u0014G.[:iKJT1aQAy\u0015\u0011\t\u00190!>\u0002\t\r|'/\u001a\u0006\u0003\u0003o\fqA]3bGR|'/\u0003\u0003\u0002|\u0006-(!B*N_:|\u0007cA!\u0002\u0000&\u0019!\u0011\u0001\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u000bY\u0002\u0019\u0001B\u0004\u00031i\u0017-\u001b7c_b,e/\u001a8u!\u0011\u0011IA!\u0007\u000f\t\t-!1\u0003\b\u0005\u0005\u001b\u0011\tBD\u0002g\u0005\u001fI1!a\u00196\u0013\r\u0001\u0018\u0011M\u0005\u0005\u0005+\u00119\"A\u0007NC&d'm\u001c=Fm\u0016tGo\u001d\u0006\u0004a\u0006\u0005\u0014\u0002\u0002B\u000e\u0005;\u0011A\"T1jY\n|\u00070\u0012<f]RTAA!\u0006\u0003\u0018\u0005y1/\u0019<f\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0003\u00022\n\r\u0002b\u0002B\u00139\u0001\u0007!qE\u0001\u000bU6\f\u0007o\u00115b]\u001e,\u0007\u0003BA\r\u0005SIAAa\u000b\u0002\u001c\tQ!*\\1q\u0007\"\fgnZ3\u0002\u0015\u001d,Go\u00155be\u0016,7\u000f\u0006\u0004\u00032\t\r#\u0011\u000b\t\u0006w\nM\"qG\u0005\u0005\u0005k\t\u0019A\u0001\u0003MSN$\b\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\t\tu\u0012QD\u0001\u0006[>$W\r\\\u0005\u0005\u0005\u0003\u0012YDA\u0005BG\u000e|WO\u001c;JI\"9!QI\u000fA\u0002\t\u001d\u0013!C7bS2\u0014w\u000e_%e!\u0011\u0011IE!\u0014\u000e\u0005\t-#\u0002\u0002B\u001f\u0003CJAAa\u0014\u0003L\tIQ*Y5mE>D\u0018\n\u001a\u0005\b\u0005'j\u0002\u0019\u0001B+\u0003!)8/\u001a:oC6,\u0007\u0003\u0002B,\u00057j!A!\u0017\u000b\u0007\u0005MX'\u0003\u0003\u0003^\te#\u0001C+tKJt\u0017-\\3\u0002%Q|7\u000b^1uK\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u0005\u0005G\u0012I\u0007E\u0002>\u0005KJ1Aa\u001a2\u0005A\u0019F/\u0019;f\u0007\"\fgnZ3Fm\u0016tG\u000fC\u0004\u0003&y\u0001\rAa\n\u0002\t\r|\u0007/\u001f\u000b\u00107\n=$\u0011\u000fB:\u0005k\u00129H!\u001f\u0003|!I\u0011QA\u0010\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003'y\u0002\u0013!a\u0001\u0003/A\u0011\"a\n !\u0003\u0005\r!a\u000b\t\u0013\u0005mr\u0004%AA\u0002\u0005}\u0002\"CA$?A\u0005\t\u0019AA&\u0011%\tIf\bI\u0001\u0002\u0004\ti\u0006C\u0005\u0002l}\u0001\n\u00111\u0001\u0002p\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BAU\u0011\tIAa!,\u0005\t\u0015\u0005\u0003\u0002BD\u0005#k!A!#\u000b\t\t-%QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa$C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0013IIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001a*\"\u0011q\u0003BB\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa(+\t\u0005-\"1Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)K\u000b\u0003\u0002@\t\r\u0015AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005WSC!a\u0013\u0003\u0004\u0006q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001BYU\u0011\tiFa!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0017\u0016\u0005\u0003_\u0012\u0019)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005{\u00032A\u0018B`\u0013\r\u0011\tm\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u001d\u0007cA!\u0003J&\u0019!1\u001a\"\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE'q\u001b\t\u0004\u0003\nM\u0017b\u0001Bk\u0005\n\u0019\u0011I\\=\t\u0013\te\u0017&!AA\u0002\t\u001d\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003`B1!\u0011\u001dBt\u0005#l!Aa9\u000b\u0007\t\u0015()\u0001\u0006d_2dWm\u0019;j_:LAA!;\u0003d\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYNa<\t\u0013\te7&!AA\u0002\tE\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!0\u0003v\"I!\u0011\u001c\u0017\u0002\u0002\u0003\u0007!qY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!qY\u0001\ti>\u001cFO]5oOR\u0011!QX\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m71\u0001\u0005\n\u00053|\u0013\u0011!a\u0001\u0005#Dq!!\u0002\u0006\u0001\u0004\tI\u0001C\u0004\u0002\u0014\u0015\u0001\r!a\u0006\t\u000f\u0005\u001dR\u00011\u0001\u0002,!9\u00111H\u0003A\u0002\u0005}\u0002bBA$\u000b\u0001\u0007\u00111\n\u0005\b\u00033*\u0001\u0019AA/\u0011\u001d\tY'\u0002a\u0001\u0003_\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0018\r\r\u0002#B!\u0004\u001a\ru\u0011bAB\u000e\u0005\n1q\n\u001d;j_:\u0004\u0012#QB\u0010\u0003\u0013\t9\"a\u000b\u0002@\u0005-\u0013QLA8\u0013\r\u0019\tC\u0011\u0002\u0007)V\u0004H.Z\u001c\t\u0011\r\u0015b!!AA\u0002m\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005i\u0006")
public class MailboxChangeListener
implements EventListener.ReactiveGroupEventListener,
Product,
Serializable {
    private final EventBus eventBus;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final MailboxChange.Factory mailboxChangeFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final EmailChange.Factory emailChangeFactory;
    private final MailboxManager mailboxManager;
    private final Clock clock;

    public static Option<Tuple7<EventBus, MailboxChangeRepository, MailboxChange.Factory, EmailChangeRepository, EmailChange.Factory, MailboxManager, Clock>> unapply(MailboxChangeListener mailboxChangeListener) {
        return MailboxChangeListener$.MODULE$.unapply(mailboxChangeListener);
    }

    public static MailboxChangeListener apply(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory factory, EmailChangeRepository emailChangeRepository, EmailChange.Factory factory2, MailboxManager mailboxManager, Clock clock) {
        return MailboxChangeListener$.MODULE$.apply(eventBus, mailboxChangeRepository, factory, emailChangeRepository, factory2, mailboxManager, clock);
    }

    public static Logger LOGGER() {
        return MailboxChangeListener$.MODULE$.LOGGER();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public void event(Event x$1) throws Exception {
        super.event(x$1);
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public MailboxChangeRepository mailboxChangeRepository() {
        return this.mailboxChangeRepository;
    }

    public MailboxChange.Factory mailboxChangeFactory() {
        return this.mailboxChangeFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    public EmailChange.Factory emailChangeFactory() {
        return this.emailChangeFactory;
    }

    public MailboxManager mailboxManager() {
        return this.mailboxManager;
    }

    public Clock clock() {
        return this.clock;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        return this.handleEvent((MailboxEvents.MailboxEvent)event).then(SMono$.MODULE$.empty()).asJava();
    }

    public Group getDefaultGroup() {
        return new MailboxChangeListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxEvent;
    }

    private SMono<BoxedUnit> handleEvent(MailboxEvents.MailboxEvent mailboxEvent) {
        Buffer buffer;
        ZonedDateTime now = ZonedDateTime.now(this.clock());
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        Username username = mailboxEvent.getUsername();
        MailboxEvents.MailboxEvent mailboxEvent2 = mailboxEvent;
        if (mailboxEvent2 instanceof MailboxEvents.MailboxAdded) {
            MailboxEvents.MailboxAdded mailboxAdded = (MailboxEvents.MailboxAdded)mailboxEvent2;
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxAdded(mailboxAdded, now)).asScala();
        } else if (mailboxEvent2 instanceof MailboxEvents.MailboxRenamed) {
            MailboxEvents.MailboxRenamed mailboxRenamed = (MailboxEvents.MailboxRenamed)mailboxEvent2;
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxRenamed(mailboxRenamed, now, CollectionConverters$.MODULE$.SeqHasAsJava(this.getSharees(mailboxId, username)).asJava())).asScala();
        } else if (mailboxEvent2 instanceof MailboxEvents.MailboxACLUpdated) {
            MailboxEvents.MailboxACLUpdated mailboxACLUpdated = (MailboxEvents.MailboxACLUpdated)mailboxEvent2;
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxACLUpdated(mailboxACLUpdated, now, CollectionConverters$.MODULE$.SeqHasAsJava(this.getSharees(mailboxId, username)).asJava())).asScala();
        } else if (mailboxEvent2 instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)mailboxEvent2;
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxDeletion(mailboxDeletion, now)).asScala();
        } else if (mailboxEvent2 instanceof MailboxEvents.Added) {
            MailboxEvents.Added added = (MailboxEvents.Added)mailboxEvent2;
            java.util.List sharees = CollectionConverters$.MODULE$.SeqHasAsJava(this.getSharees(mailboxId, username)).asJava();
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromAdded(added, now, sharees)).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromAdded(added, now, sharees)).asScala());
        } else if (mailboxEvent2 instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)mailboxEvent2;
            java.util.List sharees = CollectionConverters$.MODULE$.SeqHasAsJava(this.getSharees(mailboxId, username)).asJava();
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromFlagsUpdated(flagsUpdated, now, sharees)).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromFlagsUpdated(flagsUpdated, now, sharees)).asScala());
        } else if (mailboxEvent2 instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)mailboxEvent2;
            List<AccountId> sharees = this.getSharees(mailboxId, username);
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromExpunged(expunged, now, CollectionConverters$.MODULE$.SeqHasAsJava(sharees).asJava())).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromExpunged(expunged, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees.map((Function1 & Serializable)x$1 -> x$1.getIdentifier()).map((Function1 & Serializable)x$1 -> Username.of((String)x$1))).asJava())).asScala());
        } else {
            throw new MatchError((Object)mailboxEvent2);
        }
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)buffer);
        Function1 & Serializable x$12 = (Function1 & Serializable)jmapChange -> this.saveChangeEvent((JmapChange)jmapChange);
        int x$2 = 16;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$12, 16, x$3, x$4).then();
    }

    private Publisher<Void> saveChangeEvent(JmapChange jmapChange) {
        Mono mono;
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            mono = this.mailboxChangeRepository().save(mailboxChange);
        } else if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            mono = this.emailChangeRepository().save(emailChange);
        } else {
            throw new MatchError((Object)jmapChange2);
        }
        return SMono$.MODULE$.apply((Publisher)mono).then(SMono$.MODULE$.apply((Publisher)this.eventBus().dispatch((Event)this.toStateChangeEvent(jmapChange), (RegistrationKey)new AccountIdRegistrationKey(jmapChange.getAccountId()))));
    }

    private List<AccountId> getSharees(MailboxId mailboxId, Username username) {
        List list;
        MailboxSession mailboxSession = this.mailboxManager().createSystemSession(username);
        try {
            MailboxACL mailboxACL = this.mailboxManager().listRights(mailboxId, mailboxSession);
            list = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(mailboxACL.getEntries().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$1(x$2)))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$2(x$3)))).map((Function1 & Serializable)x$4 -> x$4.getName())).map((Function1 & Serializable)x$1 -> AccountId.fromString((String)x$1))).toList();
        }
        catch (MailboxException e) {
            MailboxChangeListener$.MODULE$.LOGGER().warn("Could not get sharees for mailbox [%s] when listening to change events", (Object)mailboxId);
            list = package$.MODULE$.List().empty();
        }
        return list;
    }

    private StateChangeEvent toStateChangeEvent(JmapChange jmapChange) {
        StateChangeEvent stateChangeEvent;
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            Event.EventId x$1 = Event.EventId.random();
            Username x$2 = Username.of((String)emailChange.getAccountId().getIdentifier());
            None$ x$3 = None$.MODULE$;
            Some x$4 = new Some((Object)State$.MODULE$.fromJava(emailChange.getState()));
            Option x$52 = new Some((Object)State$.MODULE$.fromJava(emailChange.getState())).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$toStateChangeEvent$1(emailChange, x$5)));
            None$ x$6 = None$.MODULE$;
            stateChangeEvent = new StateChangeEvent(x$1, x$2, (Option<State>)x$3, (Option<State>)x$6, (Option<State>)x$4, (Option<State>)x$52);
        } else if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            Event.EventId x$7 = Event.EventId.random();
            Username x$8 = Username.of((String)mailboxChange.getAccountId().getIdentifier());
            None$ x$9 = None$.MODULE$;
            None$ x$10 = None$.MODULE$;
            None$ x$11 = None$.MODULE$;
            Some x$12 = new Some((Object)State$.MODULE$.fromJava(mailboxChange.getState()));
            stateChangeEvent = new StateChangeEvent(x$7, x$8, (Option<State>)x$9, (Option<State>)x$12, (Option<State>)x$10, (Option<State>)x$11);
        } else {
            throw new MatchError((Object)jmapChange2);
        }
        return stateChangeEvent;
    }

    public MailboxChangeListener copy(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, EmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        return new MailboxChangeListener(eventBus, mailboxChangeRepository, mailboxChangeFactory, emailChangeRepository, emailChangeFactory, mailboxManager, clock);
    }

    public EventBus copy$default$1() {
        return this.eventBus();
    }

    public MailboxChangeRepository copy$default$2() {
        return this.mailboxChangeRepository();
    }

    public MailboxChange.Factory copy$default$3() {
        return this.mailboxChangeFactory();
    }

    public EmailChangeRepository copy$default$4() {
        return this.emailChangeRepository();
    }

    public EmailChange.Factory copy$default$5() {
        return this.emailChangeFactory();
    }

    public MailboxManager copy$default$6() {
        return this.mailboxManager();
    }

    public Clock copy$default$7() {
        return this.clock();
    }

    public String productPrefix() {
        return "MailboxChangeListener";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.eventBus();
                break;
            }
            case 1: {
                object = this.mailboxChangeRepository();
                break;
            }
            case 2: {
                object = this.mailboxChangeFactory();
                break;
            }
            case 3: {
                object = this.emailChangeRepository();
                break;
            }
            case 4: {
                object = this.emailChangeFactory();
                break;
            }
            case 5: {
                object = this.mailboxManager();
                break;
            }
            case 6: {
                object = this.clock();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MailboxChangeListener;
    }

    public String productElementName(int x$1) {
        String string2;
        int n = x$1;
        switch (n) {
            case 0: {
                string2 = "eventBus";
                break;
            }
            case 1: {
                string2 = "mailboxChangeRepository";
                break;
            }
            case 2: {
                string2 = "mailboxChangeFactory";
                break;
            }
            case 3: {
                string2 = "emailChangeRepository";
                break;
            }
            case 4: {
                string2 = "emailChangeFactory";
                break;
            }
            case 5: {
                string2 = "mailboxManager";
                break;
            }
            case 6: {
                string2 = "clock";
                break;
            }
            default: {
                string2 = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string2;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MailboxChangeListener)) return false;
        boolean bl = true;
        if (!bl) return false;
        MailboxChangeListener mailboxChangeListener = (MailboxChangeListener)x$1;
        EventBus eventBus = this.eventBus();
        EventBus eventBus2 = mailboxChangeListener.eventBus();
        if (eventBus == null) {
            if (eventBus2 != null) {
                return false;
            }
        } else if (!eventBus.equals(eventBus2)) return false;
        MailboxChangeRepository mailboxChangeRepository = this.mailboxChangeRepository();
        MailboxChangeRepository mailboxChangeRepository2 = mailboxChangeListener.mailboxChangeRepository();
        if (mailboxChangeRepository == null) {
            if (mailboxChangeRepository2 != null) {
                return false;
            }
        } else if (!mailboxChangeRepository.equals(mailboxChangeRepository2)) return false;
        MailboxChange.Factory factory = this.mailboxChangeFactory();
        MailboxChange.Factory factory2 = mailboxChangeListener.mailboxChangeFactory();
        if (factory == null) {
            if (factory2 != null) {
                return false;
            }
        } else if (!factory.equals(factory2)) return false;
        EmailChangeRepository emailChangeRepository = this.emailChangeRepository();
        EmailChangeRepository emailChangeRepository2 = mailboxChangeListener.emailChangeRepository();
        if (emailChangeRepository == null) {
            if (emailChangeRepository2 != null) {
                return false;
            }
        } else if (!emailChangeRepository.equals(emailChangeRepository2)) return false;
        EmailChange.Factory factory3 = this.emailChangeFactory();
        EmailChange.Factory factory4 = mailboxChangeListener.emailChangeFactory();
        if (factory3 == null) {
            if (factory4 != null) {
                return false;
            }
        } else if (!factory3.equals(factory4)) return false;
        MailboxManager mailboxManager = this.mailboxManager();
        MailboxManager mailboxManager2 = mailboxChangeListener.mailboxManager();
        if (mailboxManager == null) {
            if (mailboxManager2 != null) {
                return false;
            }
        } else if (!mailboxManager.equals(mailboxManager2)) return false;
        Clock clock = this.clock();
        Clock clock2 = mailboxChangeListener.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!((Object)clock).equals(clock2)) return false;
        if (!mailboxChangeListener.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$1(MailboxACL.EntryKey x$2) {
        return !x$2.isNegative();
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$2(MailboxACL.EntryKey x$3) {
        MailboxACL.NameType nameType = x$3.getNameType();
        MailboxACL.NameType nameType2 = MailboxACL.NameType.user;
        return !(nameType != null ? !nameType.equals(nameType2) : nameType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$toStateChangeEvent$1(EmailChange x2$1, State x$5) {
        return !x2$1.getCreated().isEmpty();
    }

    @Inject
    public MailboxChangeListener(@Named(value="JMAP") EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, EmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        this.eventBus = eventBus;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.mailboxChangeFactory = mailboxChangeFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.emailChangeFactory = emailChangeFactory;
        this.mailboxManager = mailboxManager;
        this.clock = clock;
        Product.$init$((Product)this);
    }
}

