/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Booleans;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.util.streams.Iterators;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ForceDelivery;
import org.apache.james.webadmin.dto.MailQueueDTO;
import org.apache.james.webadmin.dto.MailQueueItemDTO;
import org.apache.james.webadmin.service.ClearMailQueueTask;
import org.apache.james.webadmin.service.DeleteMailsFromMailQueueTask;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.apache.james.webadmin.utils.Responses;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"MailQueues"})
@Path(value="/mailQueues")
@Produces(value={"application/json"})
public class MailQueueRoutes
implements Routes {
    public static final String BASE_URL = "/mailQueues";
    @VisibleForTesting
    static final String MAIL_QUEUE_NAME = ":mailQueueName";
    @VisibleForTesting
    static final String MAILS = "/mails";
    private static final String DELAYED_QUERY_PARAM = "delayed";
    private static final String LIMIT_QUERY_PARAM = "limit";
    @VisibleForTesting
    static final int DEFAULT_LIMIT_VALUE = 100;
    private static final String SENDER_QUERY_PARAM = "sender";
    private static final String NAME_QUERY_PARAM = "name";
    private static final String RECIPIENT_QUERY_PARAM = "recipient";
    private final MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory;
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<ForceDelivery> jsonExtractor;
    private final TaskManager taskManager;

    @Inject
    @VisibleForTesting
    MailQueueRoutes(MailQueueFactory<? extends ManageableMailQueue> mailQueueFactory, JsonTransformer jsonTransformer, TaskManager taskManager) {
        this.mailQueueFactory = mailQueueFactory;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(ForceDelivery.class, new Module[0]);
        this.taskManager = taskManager;
    }

    public String getBasePath() {
        return BASE_URL;
    }

    public void define(Service service) {
        this.defineListQueues(service);
        this.getMailQueue(service);
        this.listMails(service);
        this.deleteMails(service);
        this.forceDelayedMailsDelivery(service);
    }

    @GET
    @ApiOperation(value="Listing existing MailQueues")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineListQueues(Service service) {
        service.get(BASE_URL, (request, response) -> this.mailQueueFactory.listCreatedMailQueues().stream().map(MailQueueName::asString).collect(Guavate.toImmutableList()), (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @Path(value="/{mailQueueName}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="mailQueueName", paramType="path")})
    @ApiOperation(value="Get a MailQueue details")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=MailQueueDTO.class), @ApiResponse(code=400, message="Invalid request for getting the mail queue."), @ApiResponse(code=404, message="The MailQueue does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void getMailQueue(Service service) {
        service.get("/mailQueues/:mailQueueName", (request, response) -> this.getMailQueue(request), (ResponseTransformer)this.jsonTransformer);
    }

    private MailQueueDTO getMailQueue(Request request) {
        MailQueueName mailQueueName = MailQueueName.of((String)request.params(MAIL_QUEUE_NAME));
        return this.mailQueueFactory.getQueue(mailQueueName).map(this::toDTO).orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{mailQueueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
    }

    private MailQueueDTO toDTO(ManageableMailQueue queue) {
        try {
            return MailQueueDTO.from(queue);
        }
        catch (MailQueue.MailQueueException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for getting the mail queue %s", new Object[]{queue}).cause((Exception)((Object)e)).haltError();
        }
    }

    @GET
    @Path(value="/{mailQueueName}/mails")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="mailQueueName", paramType="path"), @ApiImplicitParam(required=false, dataType="boolean", name="delayed", paramType="query", example="?delayed=true", value="Whether the mails are delayed in the mail queue or not (already sent)."), @ApiImplicitParam(required=false, dataType="int", name="limit", paramType="query", example="?limit=100", defaultValue="100", value="Limits the maximum number of mails returned by this endpoint")})
    @ApiOperation(value="List the mails of the MailQueue")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=404, message="The MailQueue does not exist."), @ApiResponse(code=400, message="Invalid request for listing the mails from the mail queue."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void listMails(Service service) {
        service.get("/mailQueues/:mailQueueName/mails", (request, response) -> this.listMails(request), (ResponseTransformer)this.jsonTransformer);
    }

    private List<MailQueueItemDTO> listMails(Request request) {
        MailQueueName mailQueueName = MailQueueName.of((String)request.params(MAIL_QUEUE_NAME));
        return this.mailQueueFactory.getQueue(mailQueueName).map(queue -> this.listMails((ManageableMailQueue)queue, this.isDelayed(request.queryParams(DELAYED_QUERY_PARAM)), ParametersExtractor.extractLimit((Request)request))).orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{mailQueueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
    }

    @VisibleForTesting
    Optional<Boolean> isDelayed(String delayedAsString) {
        return Optional.ofNullable(delayedAsString).map(Boolean::parseBoolean);
    }

    private List<MailQueueItemDTO> listMails(ManageableMailQueue queue, Optional<Boolean> isDelayed, Limit limit) {
        List list;
        block9: {
            ManageableMailQueue closeable = queue;
            try {
                list = (List)limit.applyOnStream(Iterators.toStream((Iterator)queue.browse())).map(Throwing.function(MailQueueItemDTO::from).sneakyThrow()).filter(item -> this.filter((MailQueueItemDTO)item, isDelayed)).collect(Guavate.toImmutableList());
                if (closeable == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MailQueue.MailQueueException e) {
                    throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for listing the mails from the mail queue %s", new Object[]{queue}).cause((Exception)((Object)e)).haltError();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            closeable.close();
        }
        return list;
    }

    private boolean filter(MailQueueItemDTO item, Optional<Boolean> isDelayed) {
        boolean mailIsDelayed = item.getNextDelivery().map(date -> date.isAfter(ZonedDateTime.now())).orElse(false);
        return isDelayed.map(delayed -> delayed == mailIsDelayed).orElse(true);
    }

    @DELETE
    @Path(value="/{mailQueueName}/mails")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="mailQueueName", paramType="path"), @ApiImplicitParam(required=false, dataTypeClass=MailAddress.class, name="sender", paramType="query", example="?sender=sender@james.org", value="The sender of the mails to be deleted should be equals to this query parameter."), @ApiImplicitParam(required=false, dataType="String", name="name", paramType="query", example="?name=mailName", value="The name of the mails to be deleted should be equals to this query parameter."), @ApiImplicitParam(required=false, dataType="MailAddress", name="recipient", paramType="query", example="?recipient=recipient@james.org", value="The recipients of the mails to be deleted should contain this query parameter.")})
    @ApiOperation(value="Delete mails from the MailQueue")
    @ApiResponses(value={@ApiResponse(code=201, message="OK, the task for deleting mails is created"), @ApiResponse(code=404, message="The MailQueue does not exist."), @ApiResponse(code=400, message="Invalid request for deleting mails from the mail queue."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void deleteMails(Service service) {
        TaskFromRequest taskFromRequest = this::deleteMails;
        service.delete("/mailQueues/:mailQueueName/mails", taskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    private Task deleteMails(Request request) {
        MailQueueName mailQueueName = MailQueueName.of((String)request.params(MAIL_QUEUE_NAME));
        this.checkQueueExists(mailQueueName);
        return this.deleteMailsTask(mailQueueName, this.sender(request.queryParams(SENDER_QUERY_PARAM)), this.name(request.queryParams(NAME_QUERY_PARAM)), this.recipient(request.queryParams(RECIPIENT_QUERY_PARAM)));
    }

    private Optional<MailAddress> sender(String senderAsString) throws HaltException {
        try {
            return Optional.ofNullable(senderAsString).map(Throwing.function(sender -> new MailAddress(sender)).sneakyThrow());
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("'sender' should be a mail address (i.e. sender@james.org)").cause(e).haltError();
        }
    }

    private Optional<String> name(String nameAsString) {
        return Optional.ofNullable(nameAsString);
    }

    private Optional<MailAddress> recipient(String recipientAsString) throws HaltException {
        try {
            return Optional.ofNullable(recipientAsString).map(Throwing.function(recipient -> new MailAddress(recipient)).sneakyThrow());
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("'recipient' should be a mail address (i.e. recipient@james.org)").cause(e).haltError();
        }
    }

    @PATCH
    @Path(value="/{mailQueueName}/mails")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="mailQueueName", paramType="path"), @ApiImplicitParam(required=false, dataType="boolean", name="delayed", paramType="query", example="?delayed=true", value="Whether the mails are delayed in the mail queue or not (already sent).")})
    @ApiOperation(value="Force delayed mails delivery")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid request for getting the mail queue."), @ApiResponse(code=404, message="The MailQueue does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void forceDelayedMailsDelivery(Service service) {
        service.patch("/mailQueues/:mailQueueName/mails", this::forceDelayedMailsDelivery, (ResponseTransformer)this.jsonTransformer);
    }

    private String forceDelayedMailsDelivery(Request request, Response response) throws JsonExtractException, MailQueue.MailQueueException {
        this.assertDelayedParamIsTrue(request);
        this.assertPayloadContainsDelayedEntry(request);
        try (ManageableMailQueue mailQueue = this.assertMailQueueExists(request);){
            mailQueue.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Responses.returnNoContent((Response)response);
    }

    private ManageableMailQueue assertMailQueueExists(Request request) {
        MailQueueName mailQueueName = MailQueueName.of((String)request.params(MAIL_QUEUE_NAME));
        return (ManageableMailQueue)this.mailQueueFactory.getQueue(mailQueueName).orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{mailQueueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
    }

    private void assertPayloadContainsDelayedEntry(Request request) {
        try {
            if (((ForceDelivery)this.jsonExtractor.parse(request.body())).getDelayed().orElse(true).booleanValue()) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("This request requires payload to contain delayed attribute set to false").haltError();
            }
        }
        catch (JsonExtractException e) {
            throw ErrorResponder.builder().type(ErrorResponder.ErrorType.INVALID_ARGUMENT).statusCode(400).message("Invalid JSON document: " + e.getMessage()).cause((Exception)((Object)e)).haltError();
        }
    }

    private Task deleteMailsTask(MailQueueName queueName, Optional<MailAddress> maybeSender, Optional<String> maybeName, Optional<MailAddress> maybeRecipient) {
        int paramCount = Booleans.countTrue((boolean[])new boolean[]{maybeSender.isPresent(), maybeName.isPresent(), maybeRecipient.isPresent()});
        switch (paramCount) {
            case 0: {
                return new ClearMailQueueTask(queueName, this::getQueue);
            }
            case 1: {
                return new DeleteMailsFromMailQueueTask(queueName, this::getQueue, maybeSender, maybeName, maybeRecipient);
            }
        }
        throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("You should provide only one of the query parameters 'sender', 'name', 'recipient' for deleting mails by condition or no parameter for deleting all mails in the mail queue.").haltError();
    }

    private ManageableMailQueue getQueue(MailQueueName queueName) throws MailQueue.MailQueueException {
        return (ManageableMailQueue)this.mailQueueFactory.getQueue(queueName).orElseThrow(() -> new MailQueue.MailQueueException("unable to find queue " + queueName.asString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManageableMailQueue checkQueueExists(MailQueueName queueName) {
        Optional queue = this.mailQueueFactory.getQueue(queueName);
        try {
            ManageableMailQueue manageableMailQueue = (ManageableMailQueue)queue.orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{queueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
            return manageableMailQueue;
        }
        finally {
            queue.ifPresent(Throwing.consumer(Closeable::close));
        }
    }

    private void assertDelayedParamIsTrue(Request request) {
        if (!this.isDelayed(request.queryParams(DELAYED_QUERY_PARAM)).orElse(false).booleanValue()) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("This request requires delayed param to be set to true").haltError();
        }
    }
}

