/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class RetentionConfiguration {
    public static final RetentionConfiguration DEFAULT = new RetentionConfiguration(ChronoUnit.YEARS.getDuration());
    private final Duration retentionPeriod;

    public static RetentionConfiguration from(Configuration propertiesConfiguration) {
        return Optional.ofNullable(propertiesConfiguration.getString("retentionPeriod")).map(string -> DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.DAYS)).map(RetentionConfiguration::new).orElse(DEFAULT);
    }

    RetentionConfiguration(Duration retentionPeriod) {
        Preconditions.checkNotNull((Object)retentionPeriod);
        this.retentionPeriod = retentionPeriod;
    }

    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public final boolean equals(Object o) {
        if (o instanceof RetentionConfiguration) {
            RetentionConfiguration that = (RetentionConfiguration)o;
            return Objects.equals(this.retentionPeriod, that.retentionPeriod);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.retentionPeriod);
    }
}

