/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.draft.exceptions.BadRequestException;
import org.apache.james.jmap.draft.exceptions.InternalErrorException;
import org.apache.james.jmap.draft.model.UploadResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class UploadRoutes
implements JMAPRoutes {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadRoutes.class);
    private final MetricFactory metricFactory;
    private final Authenticator authenticator;
    private final AttachmentManager attachmentManager;
    private final ObjectMapper objectMapper;

    @Inject
    private UploadRoutes(MetricFactory metricFactory, @Named(value="DRAFT") Authenticator authenticator, AttachmentManager attachmentManager, ObjectMapper objectMapper) {
        this.metricFactory = metricFactory;
        this.authenticator = authenticator;
        this.attachmentManager = attachmentManager;
        this.objectMapper = objectMapper;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of(JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, "/upload")).action(this::post).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/upload")).action(CORS_CONTROL).noCorsHeaders());
    }

    private Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        String contentType = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (Strings.isNullOrEmpty((String)contentType)) {
            return response.status(HttpResponseStatus.BAD_REQUEST).send();
        }
        return this.authenticator.authenticate(request).flatMap(session -> this.post(request, response, ContentType.of((String)contentType), (MailboxSession)session).subscriberContext(LoggingHelper.jmapAuthContext(session))).onErrorResume(CancelledUploadException.class, e -> this.handleCanceledUpload(response, (CancelledUploadException)e)).onErrorResume(BadRequestException.class, e -> this.handleBadRequest(response, (BadRequestException)e)).onErrorResume(UnauthorizedException.class, e -> this.handleAuthenticationFailure(response, LOGGER, (Throwable)e)).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Unexpected error", e))).onErrorResume(e -> this.handleInternalError(response, LOGGER, (Throwable)e)).subscriberContext(LoggingHelper.jmapContext(request)).subscriberContext(LoggingHelper.jmapAction("upload-get")).subscribeOn(Schedulers.elastic());
    }

    private Mono<Void> post(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession session) {
        InputStream content = ReactorUtils.toInputStream((Flux)request.receive().asByteArray().map(ByteBuffer::wrap).subscribeOn(Schedulers.elastic()));
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-upload-post", this.handle(contentType, content, session, response)));
    }

    private Mono<Void> handle(ContentType contentType, InputStream content, MailboxSession mailboxSession, HttpServerResponse response) {
        return this.uploadContent(contentType, content, mailboxSession).flatMap(storedContent -> {
            try {
                return response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.CREATED).sendString((Publisher)Mono.just((Object)this.objectMapper.writeValueAsString(storedContent))).then();
            }
            catch (JsonProcessingException e) {
                throw new InternalErrorException("Error serializing upload response", e);
            }
        });
    }

    private Mono<UploadResponse> uploadContent(ContentType contentType, InputStream inputStream, MailboxSession session) {
        return Mono.from((Publisher)this.attachmentManager.storeAttachment(contentType, inputStream, session)).map(attachment -> UploadResponse.builder().blobId(attachment.getAttachmentId().getId()).type(attachment.getType().asString()).size(attachment.getSize()).build()).onErrorMap(e -> e.getCause() instanceof EOFException, any -> new CancelledUploadException()).onErrorMap(e -> !(e instanceof CancelledUploadException), e -> new InternalErrorException("Error while uploading content", (Throwable)e));
    }

    private Mono<Void> handleCanceledUpload(HttpServerResponse response, CancelledUploadException e) {
        LOGGER.info("An upload has been canceled before the end", (Throwable)e);
        return response.send();
    }

    private Mono<Void> handleBadRequest(HttpServerResponse response, BadRequestException e) {
        LOGGER.warn("Invalid authentication request received.", (Throwable)e);
        return response.status(HttpResponseStatus.BAD_REQUEST).send();
    }

    static class CancelledUploadException
    extends RuntimeException {
        CancelledUploadException() {
        }
    }
}

