/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.draft.api.AccessTokenManager;
import org.apache.james.jmap.draft.api.SimpleTokenFactory;
import org.apache.james.jmap.draft.api.SimpleTokenManager;
import org.apache.james.jmap.draft.exceptions.BadRequestException;
import org.apache.james.jmap.draft.exceptions.InternalErrorException;
import org.apache.james.jmap.draft.json.MultipleObjectMapperBuilder;
import org.apache.james.jmap.draft.model.AccessTokenRequest;
import org.apache.james.jmap.draft.model.AccessTokenResponse;
import org.apache.james.jmap.draft.model.ContinuationTokenRequest;
import org.apache.james.jmap.draft.model.ContinuationTokenResponse;
import org.apache.james.jmap.draft.model.EndPointsResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class AuthenticationRoutes
implements JMAPRoutes {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationRoutes.class);
    private final ObjectMapper mapper = new MultipleObjectMapperBuilder().registerClass("/username", ContinuationTokenRequest.class).registerClass("/token", AccessTokenRequest.class).build();
    private final UsersRepository usersRepository;
    private final SimpleTokenManager simpleTokenManager;
    private final AccessTokenManager accessTokenManager;
    private final SimpleTokenFactory simpleTokenFactory;
    private final MetricFactory metricFactory;
    private final Authenticator authenticator;

    @Inject
    public AuthenticationRoutes(UsersRepository usersRepository, SimpleTokenManager simpleTokenManager, AccessTokenManager accessTokenManager, SimpleTokenFactory simpleTokenFactory, MetricFactory metricFactory, @Named(value="DRAFT") Authenticator authenticator) {
        this.usersRepository = usersRepository;
        this.simpleTokenManager = simpleTokenManager;
        this.accessTokenManager = accessTokenManager;
        this.simpleTokenFactory = simpleTokenFactory;
        this.metricFactory = metricFactory;
        this.authenticator = authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of(JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, "/authentication")).action(this::post).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/authentication")).action(this::returnEndPointsResponse).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.DELETE, "/authentication")).action(this::delete).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/authentication")).action(CORS_CONTROL).noCorsHeaders());
    }

    private Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetricLogP99("JMAP-authentication-post", (Publisher)Mono.just((Object)request).map(this::assertJsonContentType).map(this::assertAcceptJsonOnly).flatMap(this::deserialize).flatMap(objectRequest -> {
            if (objectRequest instanceof ContinuationTokenRequest) {
                return this.handleContinuationTokenRequest((ContinuationTokenRequest)objectRequest, response);
            }
            if (objectRequest instanceof AccessTokenRequest) {
                return this.handleAccessTokenRequest((AccessTokenRequest)objectRequest, response);
            }
            throw new RuntimeException(objectRequest.getClass() + " " + objectRequest);
        }))).onErrorResume(BadRequestException.class, e -> this.handleBadRequest(response, LOGGER, (Throwable)e)).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Unexpected error", e))).onErrorResume(e -> this.handleInternalError(response, LOGGER, (Throwable)e)).subscriberContext(LoggingHelper.jmapContext(request)).subscriberContext(LoggingHelper.jmapAction("auth-post")).subscribeOn(Schedulers.elastic());
    }

    private Mono<Void> returnEndPointsResponse(HttpServerRequest req, HttpServerResponse resp) {
        return this.authenticator.authenticate(req).flatMap(session -> this.returnEndPointsResponse(resp).subscriberContext(LoggingHelper.jmapAuthContext(session))).onErrorResume(IllegalArgumentException.class, e -> this.handleBadRequest(resp, LOGGER, (Throwable)e)).onErrorResume(BadRequestException.class, e -> this.handleBadRequest(resp, LOGGER, (Throwable)e)).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Unexpected error", e))).onErrorResume(InternalErrorException.class, e -> this.handleInternalError(resp, LOGGER, (Throwable)e)).onErrorResume(UnauthorizedException.class, e -> this.handleAuthenticationFailure(resp, LOGGER, (Throwable)e)).subscriberContext(LoggingHelper.jmapContext(req)).subscriberContext(LoggingHelper.jmapAction("returnEndPoints")).subscribeOn(Schedulers.elastic());
    }

    private Mono<Void> returnEndPointsResponse(HttpServerResponse resp) {
        try {
            return resp.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").sendString((Publisher)Mono.just((Object)this.mapper.writeValueAsString((Object)EndPointsResponse.builder().api("/jmap").eventSource("/notImplemented").upload("/upload").download("/download").build()))).then();
        }
        catch (JsonProcessingException e) {
            throw new InternalErrorException("Error serializing endpoint response", e);
        }
    }

    private Mono<Void> delete(HttpServerRequest req, HttpServerResponse resp) {
        String authorizationHeader = req.requestHeaders().get("Authorization");
        return this.authenticator.authenticate(req).flatMap(session -> Mono.from(this.accessTokenManager.revoke(AccessToken.fromString((String)authorizationHeader))).then(resp.status(HttpResponseStatus.NO_CONTENT).send().then()).subscriberContext(LoggingHelper.jmapAuthContext(session))).onErrorResume(UnauthorizedException.class, e -> this.handleAuthenticationFailure(resp, LOGGER, (Throwable)e)).subscriberContext(LoggingHelper.jmapContext(req)).subscriberContext(LoggingHelper.jmapAction("auth-delete")).subscribeOn(Schedulers.elastic());
    }

    private HttpServerRequest assertJsonContentType(HttpServerRequest req) {
        if (!Objects.equals(req.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE), "application/json; charset=UTF-8")) {
            throw new BadRequestException("Request ContentType header must be set to: application/json; charset=UTF-8");
        }
        return req;
    }

    private HttpServerRequest assertAcceptJsonOnly(HttpServerRequest req) {
        String accept = req.requestHeaders().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (accept == null || !accept.contains("application/json")) {
            throw new BadRequestException("Request Accept header must be set to JSON content type");
        }
        return req;
    }

    private Mono<Object> deserialize(HttpServerRequest req) {
        return req.receive().aggregate().asInputStream().map(inputStream -> {
            try {
                return this.mapper.readValue(inputStream, Object.class);
            }
            catch (IOException e) {
                throw new BadRequestException("Request can't be deserialized", e);
            }
        }).switchIfEmpty(Mono.error((Throwable)new BadRequestException("Empty body")));
    }

    private Mono<Void> handleContinuationTokenRequest(ContinuationTokenRequest request, HttpServerResponse resp) {
        try {
            ContinuationTokenResponse continuationTokenResponse = ContinuationTokenResponse.builder().continuationToken(this.simpleTokenFactory.generateContinuationToken(request.getUsername())).methods(ContinuationTokenResponse.AuthenticationMethod.PASSWORD).build();
            return resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").sendString((Publisher)Mono.just((Object)this.mapper.writeValueAsString((Object)continuationTokenResponse))).then();
        }
        catch (Exception e) {
            throw new InternalErrorException("Error while responding to continuation token", e);
        }
    }

    private Mono<Void> handleAccessTokenRequest(AccessTokenRequest request, HttpServerResponse resp) {
        SimpleTokenManager.TokenStatus validity = this.simpleTokenManager.getValidity(request.getToken());
        switch (validity) {
            case EXPIRED: {
                return this.returnForbiddenAuthentication(resp);
            }
            case INVALID: {
                return this.returnUnauthorizedResponse(resp).doOnEach(ReactorUtils.log(() -> LOGGER.warn("Use of an invalid ContinuationToken : {}", (Object)request.getToken().serialize())));
            }
            case OK: {
                return this.manageAuthenticationResponse(request, resp);
            }
        }
        throw new InternalErrorException(String.format("Validity %s is not implemented", new Object[]{validity}));
    }

    private Mono<Void> manageAuthenticationResponse(AccessTokenRequest request, HttpServerResponse resp) {
        Username username = Username.of((String)request.getToken().getUsername());
        return this.authenticate(request, username).flatMap(success -> {
            if (success.booleanValue()) {
                return this.returnAccessTokenResponse(resp, username);
            }
            return this.returnUnauthorizedResponse(resp).doOnEach(ReactorUtils.log(() -> LOGGER.info("Authentication failure for {}", (Object)username)));
        });
    }

    private Mono<Boolean> authenticate(AccessTokenRequest request, Username username) {
        return Mono.fromCallable(() -> {
            try {
                return this.usersRepository.test(username, request.getPassword());
            }
            catch (UsersRepositoryException e) {
                LOGGER.error("Error while trying to validate authentication for user '{}'", (Object)username, (Object)e);
                return false;
            }
        }).subscribeOn(Schedulers.elastic());
    }

    private Mono<Void> returnAccessTokenResponse(HttpServerResponse resp, Username username) {
        return Mono.from(this.accessTokenManager.grantAccessToken(username)).map(accessToken -> AccessTokenResponse.builder().accessToken((AccessToken)accessToken).api("/jmap").eventSource("/notImplemented").upload("/upload").download("/download").build()).flatMap(accessTokenResponse -> {
            try {
                return resp.status(HttpResponseStatus.CREATED).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").sendString((Publisher)Mono.just((Object)this.mapper.writeValueAsString(accessTokenResponse))).then();
            }
            catch (JsonProcessingException e) {
                throw new InternalErrorException("Could not serialize access token response", e);
            }
        });
    }

    private Mono<Void> returnUnauthorizedResponse(HttpServerResponse resp) {
        return resp.status(HttpResponseStatus.UNAUTHORIZED).send().then();
    }

    private Mono<Void> returnForbiddenAuthentication(HttpServerResponse resp) {
        return resp.status(HttpResponseStatus.FORBIDDEN).send().then();
    }
}

