/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.james.util.html.HtmlTextExtractor;

public class MimeMessageBodyGenerator {
    public static final String MIXED = "mixed";
    public static final String EMPTY_TEXT = "";
    private final HtmlTextExtractor htmlTextExtractor;

    @Inject
    @VisibleForTesting
    MimeMessageBodyGenerator(HtmlTextExtractor htmlTextExtractor) {
        this.htmlTextExtractor = htmlTextExtractor;
    }

    public MimeMessage from(MimeMessage messageHoldingHeaders, Optional<String> plainText, Optional<String> htmlText) throws MessagingException {
        Preconditions.checkNotNull((Object)messageHoldingHeaders);
        Preconditions.checkNotNull(plainText);
        Preconditions.checkNotNull(htmlText);
        if (htmlText.isPresent()) {
            messageHoldingHeaders.setContent(this.generateMultipart(htmlText.get(), plainText));
        } else {
            messageHoldingHeaders.setText(plainText.orElse(EMPTY_TEXT));
        }
        return messageHoldingHeaders;
    }

    private Multipart generateMultipart(String htmlText, Optional<String> plainText) throws MessagingException {
        try {
            MimeMultipart multipart = new MimeMultipart(MIXED);
            this.addTextPart((Multipart)multipart, htmlText, "text/html");
            this.addTextPart((Multipart)multipart, this.retrievePlainTextMessage(plainText, htmlText), "text/plain");
            return multipart;
        }
        catch (IOException e) {
            throw new MessagingException("Cannot read specified content", (Exception)e);
        }
    }

    private Multipart addTextPart(Multipart multipart, String text, String contentType) throws MessagingException, IOException {
        MimeBodyPart textReasonPart = new MimeBodyPart();
        textReasonPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(text, contentType + "; charset=UTF-8")));
        multipart.addBodyPart((BodyPart)textReasonPart);
        return multipart;
    }

    private String retrievePlainTextMessage(Optional<String> plainText, String htmlText) {
        return plainText.orElseGet(() -> this.htmlTextExtractor.toPlainText(htmlText));
    }
}

