/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.jmap.draft.utils.KeywordsCombiner;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageViewFactory<T extends MessageView> {
    public static final Logger LOGGER = LoggerFactory.getLogger(MessageViewFactory.class);
    public static final KeywordsCombiner KEYWORDS_COMBINER = new KeywordsCombiner();
    public static final Keywords.KeywordsFactory KEYWORDS_FACTORY = Keywords.lenientFactory();
    public static final String JMAP_MULTIVALUED_FIELD_DELIMITER = "\n";

    public Flux<T> fromMessageIds(List<MessageId> var1, MailboxSession var2);

    public static class Helpers {
        static void assertOneMessageId(Collection<MessageResult> messageResults) {
            Preconditions.checkArgument((!messageResults.isEmpty() ? 1 : 0) != 0, (Object)"MessageResults cannot be empty");
            Preconditions.checkArgument((boolean)Helpers.hasOnlyOneMessageId(messageResults), (Object)"MessageResults need to share the same messageId");
        }

        private static boolean hasOnlyOneMessageId(Collection<MessageResult> messageResults) {
            return messageResults.stream().map(MessageResult::getMessageId).distinct().count() == 1L;
        }

        static List<MailboxId> getMailboxIds(Collection<MessageResult> messageResults) {
            return (List)messageResults.stream().map(MessageResult::getMailboxId).distinct().collect(Guavate.toImmutableList());
        }

        static Keywords getKeywords(Collection<MessageResult> messageResults) {
            return messageResults.stream().map(MessageResult::getFlags).map(KEYWORDS_FACTORY::fromFlags).reduce(KEYWORDS_COMBINER).get();
        }

        static String getHeaderValue(Message message, String header) {
            Field field = message.getHeader().getField(header);
            if (field == null) {
                return null;
            }
            return field.getBody();
        }

        static ImmutableMap<String, String> toHeaderMap(List<Field> fields) {
            Function<Map.Entry, String> bodyConcatenator = fieldListEntry -> ((Collection)fieldListEntry.getValue()).stream().map(Field::getBody).map(MimeUtil::unscrambleHeaderValue).collect(Collectors.toList()).stream().collect(Collectors.joining(MessageViewFactory.JMAP_MULTIVALUED_FIELD_DELIMITER));
            return (ImmutableMap)Multimaps.index(fields, Field::getName).asMap().entrySet().stream().collect(Guavate.toImmutableMap(Map.Entry::getKey, bodyConcatenator));
        }

        static <T extends MessageView> Function<Collection<MessageResult>, Mono<T>> toMessageViews(FromMessageResult<T> converter) {
            return messageResults -> converter.fromMessageResults((Collection<MessageResult>)messageResults).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Can not convert MessageResults to Message for {}", (Object)((MessageResult)messageResults.iterator().next()).getMessageId().serialize(), e))).onErrorResume(e -> Mono.empty());
        }

        static <T extends MessageView> Flux<T> toMessageViews(Flux<MessageResult> messageResults, FromMessageResult<T> converter) {
            return messageResults.groupBy(MessageResult::getMessageId).flatMap(Flux::collectList, 16).filter(Predicate.not(List::isEmpty)).flatMap(Helpers.toMessageViews(converter), 16);
        }

        static Instant getDateFromHeaderOrInternalDateOtherwise(Message mimeMessage, MessageResult message) {
            return Optional.ofNullable(mimeMessage.getDate()).map(Date::toInstant).orElse(message.getInternalDate().toInstant());
        }

        static Message parse(InputStream messageContent) throws IOException {
            return Message.Builder.of().use(MimeConfig.PERMISSIVE).parse(messageContent).build();
        }

        static interface FromMessageResult<T extends MessageView> {
            public Mono<T> fromMessageResults(Collection<MessageResult> var1);
        }
    }
}

