/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.message.view.MessageMetadataView;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;
import org.apache.james.mailbox.BlobManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageMetadataViewFactory
implements MessageViewFactory<MessageMetadataView> {
    private final BlobManager blobManager;
    private final MessageIdManager messageIdManager;

    @Inject
    @VisibleForTesting
    public MessageMetadataViewFactory(BlobManager blobManager, MessageIdManager messageIdManager) {
        this.blobManager = blobManager;
        this.messageIdManager = messageIdManager;
    }

    @Override
    public Flux<MessageMetadataView> fromMessageIds(List<MessageId> messageIds, MailboxSession session) {
        Flux messages = Flux.from((Publisher)this.messageIdManager.getMessagesReactive(messageIds, FetchGroup.MINIMAL, session));
        return MessageViewFactory.Helpers.toMessageViews((Flux<MessageResult>)messages, this::fromMessageResults);
    }

    @VisibleForTesting
    public Mono<MessageMetadataView> fromMessageResults(Collection<MessageResult> messageResults) {
        MessageViewFactory.Helpers.assertOneMessageId(messageResults);
        MessageResult firstMessageResult = messageResults.iterator().next();
        List<MailboxId> mailboxIds = MessageViewFactory.Helpers.getMailboxIds(messageResults);
        return Mono.just((Object)((MessageMetadataView.Builder)((MessageMetadataView.Builder)((MessageMetadataView.Builder)((MessageMetadataView.Builder)((MessageMetadataView.Builder)((MessageMetadataView.Builder)MessageMetadataView.messageMetadataBuilder().id(firstMessageResult.getMessageId())).mailboxIds(mailboxIds)).blobId(BlobId.of(this.blobManager.toBlobId(firstMessageResult.getMessageId())))).threadId(firstMessageResult.getMessageId().serialize())).keywords(MessageViewFactory.Helpers.getKeywords(messageResults))).size(firstMessageResult.getSize())).build());
    }
}

