/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.mailbox.FlagsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keywords {
    public static final Keywords DEFAULT_VALUE = new Keywords((ImmutableSet<Keyword>)ImmutableSet.of());
    private static final Logger LOGGER = LoggerFactory.getLogger(Keywords.class);
    private static final KeywordsFactory STRICT_KEYWORDS_FACTORY = new KeywordsFactory(KeywordsFactory.KeywordsValidator.THROW_ON_IMAP_NON_EXPOSED_KEYWORDS, KeywordsFactory.KeywordFilter.KEEP_ALL, KeywordsFactory.ToKeyword.STRICT);
    private static final KeywordsFactory LENIENT_KEYWORDS_FACTORY = new KeywordsFactory(KeywordsFactory.KeywordsValidator.IGNORE_NON_EXPOSED_IMAP_KEYWORDS, KeywordsFactory.KeywordFilter.FILTER_IMAP_NON_EXPOSED_KEYWORDS, KeywordsFactory.ToKeyword.LENIENT);
    private final ImmutableSet<Keyword> keywords;

    private FlagsBuilder combiner(FlagsBuilder firstBuilder, FlagsBuilder secondBuilder) {
        return firstBuilder.add(new Flags[]{secondBuilder.build()});
    }

    private FlagsBuilder accumulator(FlagsBuilder accumulator, Keyword keyword) {
        return accumulator.add(new Flags[]{keyword.asFlags()});
    }

    public static KeywordsFactory strictFactory() {
        return STRICT_KEYWORDS_FACTORY;
    }

    public static KeywordsFactory lenientFactory() {
        return LENIENT_KEYWORDS_FACTORY;
    }

    private Keywords(ImmutableSet<Keyword> keywords) {
        this.keywords = keywords;
    }

    public Flags asFlags() {
        return this.keywords.stream().reduce(FlagsBuilder.builder(), this::accumulator, this::combiner).build();
    }

    public Flags asFlagsWithRecentAndDeletedFrom(Flags originFlags) {
        Flags flags = this.asFlags();
        if (originFlags.contains(Flags.Flag.DELETED)) {
            flags.add(Flags.Flag.DELETED);
        }
        if (originFlags.contains(Flags.Flag.RECENT)) {
            flags.add(Flags.Flag.RECENT);
        }
        return flags;
    }

    public ImmutableMap<String, Boolean> asMap() {
        return (ImmutableMap)this.keywords.stream().collect(Guavate.toImmutableMap(Keyword::getFlagName, keyword -> Keyword.FLAG_VALUE));
    }

    public ImmutableSet<Keyword> getKeywords() {
        return this.keywords;
    }

    public boolean contains(Keyword keyword) {
        return this.keywords.contains((Object)keyword);
    }

    public final boolean equals(Object other) {
        if (other instanceof Keywords) {
            Keywords otherKeyword = (Keywords)other;
            return Objects.equal(this.keywords, otherKeyword.keywords);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keywords});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keywords", this.keywords).toString();
    }

    public static class KeywordsFactory {
        private final KeywordsValidator validator;
        private final Predicate<Keyword> filter;
        private final ToKeyword toKeyword;

        public KeywordsFactory(KeywordsValidator validator, Predicate<Keyword> filter, ToKeyword toKeyword) {
            this.validator = validator;
            this.filter = filter;
            this.toKeyword = toKeyword;
        }

        public Keywords fromSet(Set<Keyword> setKeywords) {
            this.validator.validate(setKeywords);
            return new Keywords((ImmutableSet<Keyword>)((ImmutableSet)setKeywords.stream().filter(this.filter).collect(Guavate.toImmutableSet())));
        }

        public Keywords from(Keyword ... keywords) {
            return this.fromSet((Set)Arrays.stream(keywords).collect(Guavate.toImmutableSet()));
        }

        public Keywords fromCollection(Collection<String> keywords) {
            return this.fromSet((Set)keywords.stream().flatMap(this.toKeyword::asKeywordStream).collect(Guavate.toImmutableSet()));
        }

        @VisibleForTesting
        Keywords fromMap(Map<String, Boolean> mapKeywords) {
            Preconditions.checkArgument((boolean)mapKeywords.values().stream().allMatch(keywordValue -> keywordValue), (Object)"Keyword must be true");
            return this.fromCollection(mapKeywords.keySet());
        }

        public Keywords fromFlags(Flags flags) {
            return this.fromSet((Set)Stream.concat(Stream.of(flags.getUserFlags()).flatMap(this.toKeyword::asKeywordStream), Stream.of(flags.getSystemFlags()).map(Keyword::fromFlag)).collect(Guavate.toImmutableSet()));
        }

        @FunctionalInterface
        static interface ToKeyword {
            public static final ToKeyword STRICT = value -> Optional.of(Keyword.of(value));
            public static final ToKeyword LENIENT = value -> {
                Optional<Keyword> result = Keyword.parse(value);
                if (!result.isPresent()) {
                    LOGGER.warn("Fail to parse {} flag", (Object)value);
                }
                return result;
            };

            public Optional<Keyword> toKeyword(String var1);

            default public Stream<Keyword> asKeywordStream(String value) {
                return this.toKeyword(value).stream();
            }
        }

        @FunctionalInterface
        static interface KeywordFilter
        extends Predicate<Keyword> {
            public static final KeywordFilter FILTER_IMAP_NON_EXPOSED_KEYWORDS = Keyword::isExposedImapKeyword;
            public static final KeywordFilter KEEP_ALL = keyword -> true;
        }

        @FunctionalInterface
        static interface KeywordsValidator {
            public static final KeywordsValidator THROW_ON_IMAP_NON_EXPOSED_KEYWORDS = keywords -> Preconditions.checkArgument((boolean)keywords.stream().allMatch(Keyword::isExposedImapKeyword), (Object)"Does not allow to update 'Deleted' or 'Recent' flag");
            public static final KeywordsValidator IGNORE_NON_EXPOSED_IMAP_KEYWORDS = keywords -> {};

            public void validate(Set<Keyword> var1);
        }
    }
}

