/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.apache.james.jmap.draft.model.SignedExpiringToken;

public class AttachmentAccessToken
implements SignedExpiringToken {
    public static final char SEPARATOR = '_';
    private final String username;
    private final String blobId;
    private final ZonedDateTime expirationDate;
    private final String signature;

    public static Builder builder() {
        return new Builder();
    }

    public static AttachmentAccessToken from(String serializedAttachmentAccessToken, String blobId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serializedAttachmentAccessToken) ? 1 : 0) != 0, (Object)"'AttachmentAccessToken' is mandatory");
        List split = Splitter.on((char)'_').splitToList((CharSequence)serializedAttachmentAccessToken);
        Preconditions.checkArgument((split.size() >= 3 ? 1 : 0) != 0, (Object)"Wrong 'AttachmentAccessToken'");
        String username = Joiner.on((char)'_').join((Iterable)split.stream().limit(split.size() - 2).collect(Guavate.toImmutableList()));
        Object defaultValue = null;
        return AttachmentAccessToken.builder().blobId(blobId).username(username).expirationDate(ZonedDateTime.parse((CharSequence)Iterables.get((Iterable)split, (int)(split.size() - 2), defaultValue))).signature((String)Iterables.get((Iterable)split, (int)(split.size() - 1), defaultValue)).build();
    }

    @VisibleForTesting
    AttachmentAccessToken(String username, String blobId, ZonedDateTime expirationDate, String signature) {
        this.username = username;
        this.blobId = blobId;
        this.expirationDate = expirationDate;
        this.signature = signature;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public String serialize() {
        return this.getPayload() + "_" + this.signature;
    }

    @Override
    public String getPayload() {
        return this.username + "_" + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate);
    }

    @Override
    public String getSignedContent() {
        return this.blobId + "_" + this.getPayload();
    }

    public boolean equals(Object other) {
        if (other instanceof AttachmentAccessToken) {
            AttachmentAccessToken attachmentAccessToken = (AttachmentAccessToken)other;
            return Objects.equals(this.username, attachmentAccessToken.username) && Objects.equals(this.blobId, attachmentAccessToken.blobId) && Objects.equals(this.expirationDate, attachmentAccessToken.expirationDate) && Objects.equals(this.signature, attachmentAccessToken.signature);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.username, this.blobId, this.expirationDate, this.signature);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).add("blobId", (Object)this.blobId).add("expirationDate", (Object)this.expirationDate).add("signature", (Object)this.signature).toString();
    }

    public static class Builder {
        private String username;
        private String blobId;
        private ZonedDateTime expirationDate;
        private String signature;

        private Builder() {
        }

        public Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder expirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature.trim();
            return this;
        }

        public AttachmentAccessToken build() {
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.blobId);
            Preconditions.checkArgument((!this.blobId.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)this.expirationDate);
            Preconditions.checkNotNull((Object)this.signature);
            return new AttachmentAccessToken(this.username, this.blobId, this.expirationDate, this.signature);
        }
    }
}

