/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.FunctionChainer;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.AttachmentsNotFoundException;
import org.apache.james.jmap.draft.exceptions.InvalidDraftKeywordsException;
import org.apache.james.jmap.draft.exceptions.InvalidMailboxForCreationException;
import org.apache.james.jmap.draft.exceptions.MailboxNotOwnedException;
import org.apache.james.jmap.draft.exceptions.MessageHasNoMailboxException;
import org.apache.james.jmap.draft.methods.AttachmentChecker;
import org.apache.james.jmap.draft.methods.MailboxInvalidMessageCreationException;
import org.apache.james.jmap.draft.methods.MailboxSendingNotAllowedException;
import org.apache.james.jmap.draft.methods.MessageAppender;
import org.apache.james.jmap.draft.methods.MessageSender;
import org.apache.james.jmap.draft.methods.ReferenceUpdater;
import org.apache.james.jmap.draft.methods.SetMailboxesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.EnvelopeUtils;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.server.core.Envelope;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class SetMessagesCreationProcessor
implements SetMessagesProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SetMailboxesCreationProcessor.class);
    private final MessageFullViewFactory messageFullViewFactory;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final AttachmentChecker attachmentChecker;
    private final MetricFactory metricFactory;
    private final MailboxManager mailboxManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageAppender messageAppender;
    private final MessageSender messageSender;
    private final ReferenceUpdater referenceUpdater;
    private final CanSendFrom canSendFrom;

    @Inject
    @VisibleForTesting
    SetMessagesCreationProcessor(MessageFullViewFactory messageFullViewFactory, SystemMailboxesProvider systemMailboxesProvider, AttachmentChecker attachmentChecker, MetricFactory metricFactory, MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory, MessageAppender messageAppender, MessageSender messageSender, ReferenceUpdater referenceUpdater, CanSendFrom canSendFrom) {
        this.messageFullViewFactory = messageFullViewFactory;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.attachmentChecker = attachmentChecker;
        this.metricFactory = metricFactory;
        this.mailboxManager = mailboxManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageAppender = messageAppender;
        this.messageSender = messageSender;
        this.referenceUpdater = referenceUpdater;
        this.canSendFrom = canSendFrom;
    }

    @Override
    public SetMessagesResponse process(SetMessagesRequest request, MailboxSession mailboxSession) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-SetMessageCreationProcessor");
        SetMessagesResponse.Builder responseBuilder = SetMessagesResponse.builder();
        request.getCreate().forEach(create -> this.handleCreate((ValueWithId.CreationMessageEntry)create, responseBuilder, mailboxSession));
        timeMetric.stopAndPublish();
        return responseBuilder.build();
    }

    private void handleCreate(ValueWithId.CreationMessageEntry create, SetMessagesResponse.Builder responseBuilder, MailboxSession mailboxSession) {
        try {
            ImmutableList<MailboxId> mailboxIds = this.toMailboxIds(create);
            this.assertAtLeastOneMailbox((List<MailboxId>)mailboxIds);
            this.assertIsUserOwnerOfMailboxes((List<MailboxId>)mailboxIds, mailboxSession);
            this.performCreate(create, responseBuilder, mailboxSession);
        }
        catch (MailboxSendingNotAllowedException e) {
            LOG.debug("{} is not allowed to send a mail using {} identity", (Object)e.getConnectedUser().asString(), e.getFromField());
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.from).description("Invalid 'from' field. One accepted value is " + e.getConnectedUser().asString()).build());
        }
        catch (InvalidDraftKeywordsException e) {
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.keywords).description(e.getMessage()).build());
        }
        catch (AttachmentsNotFoundException e) {
            responseBuilder.notCreated(create.getCreationId(), SetMessagesError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.attachments).attachmentsNotFound(e.getAttachmentIds()).description("Attachment not found").build());
        }
        catch (InvalidMailboxForCreationException e) {
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.mailboxIds).description("Message creation is only supported in mailboxes with role Draft and Outbox").build());
        }
        catch (MessageHasNoMailboxException e) {
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(MessageProperties.MessageProperty.mailboxIds).description("Message needs to be in at least one mailbox").build());
        }
        catch (MailboxInvalidMessageCreationException e) {
            responseBuilder.notCreated(create.getCreationId(), this.buildSetErrorFromValidationResult(((CreationMessage)create.getValue()).validate()));
        }
        catch (MailboxNotFoundException e) {
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description(e.getMessage()).build());
        }
        catch (MailboxNotOwnedException e) {
            LOG.error("Appending message in an unknown mailbox", (Throwable)((Object)e));
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).properties(MessageProperties.MessageProperty.mailboxIds).description("MailboxId invalid").build());
        }
        catch (OverQuotaException e) {
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.MAX_QUOTA_REACHED).description(e.getMessage()).build());
        }
        catch (IOException | MessagingException | MailboxException e) {
            LOG.error("Unexpected error while creating message", e);
            responseBuilder.notCreated(create.getCreationId(), SetError.builder().type(SetError.Type.ERROR).description("unexpected error").build());
        }
    }

    private ImmutableList<MailboxId> toMailboxIds(ValueWithId.CreationMessageEntry create) {
        return (ImmutableList)((CreationMessage)create.getValue()).getMailboxIds().stream().distinct().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableList());
    }

    private void performCreate(ValueWithId.CreationMessageEntry entry, SetMessagesResponse.Builder responseBuilder, MailboxSession session) throws MailboxException, MessagingException, AttachmentsNotFoundException, IOException {
        if (this.isAppendToMailboxWithRole(Role.OUTBOX, (CreationMessage)entry.getValue(), session)) {
            this.sendMailViaOutbox(entry, responseBuilder, session);
        } else if (((CreationMessage)entry.getValue()).isDraft()) {
            this.assertNoOutbox(entry, session);
            this.saveDraft(entry, responseBuilder, session);
        } else {
            if (this.isAppendToMailboxWithRole(Role.DRAFTS, (CreationMessage)entry.getValue(), session)) {
                throw new InvalidDraftKeywordsException("A draft message should be flagged as Draft");
            }
            throw new InvalidMailboxForCreationException("The only implemented feature is sending via outbox and draft saving");
        }
    }

    private void assertNoOutbox(ValueWithId.CreationMessageEntry entry, MailboxSession session) throws MailboxException {
        if (this.isTargettingAMailboxWithRole(Role.OUTBOX, (CreationMessage)entry.getValue(), session)) {
            throw new InvalidMailboxForCreationException("Mailbox ids can combine Outbox with other mailbox");
        }
    }

    private void assertAtLeastOneMailbox(List<MailboxId> mailboxIds) throws MailboxException {
        if (mailboxIds.isEmpty()) {
            throw new MessageHasNoMailboxException();
        }
    }

    private void sendMailViaOutbox(ValueWithId.CreationMessageEntry entry, SetMessagesResponse.Builder responseBuilder, MailboxSession session) throws AttachmentsNotFoundException, MailboxException, MessagingException, IOException {
        this.validateArguments(entry, session);
        ValueWithId.MessageWithId created = this.handleOutboxMessages(entry, session);
        responseBuilder.created(created.getCreationId(), (MessageFullView)created.getValue());
    }

    private void saveDraft(ValueWithId.CreationMessageEntry entry, SetMessagesResponse.Builder responseBuilder, MailboxSession session) throws AttachmentsNotFoundException, MailboxException, MessagingException, IOException {
        this.attachmentChecker.assertAttachmentsExist(entry, session);
        ValueWithId.MessageWithId created = this.handleDraftMessages(entry, session);
        responseBuilder.created(created.getCreationId(), (MessageFullView)created.getValue());
    }

    private void validateArguments(ValueWithId.CreationMessageEntry entry, MailboxSession session) throws MailboxInvalidMessageCreationException, AttachmentsNotFoundException, MailboxException {
        CreationMessage message = (CreationMessage)entry.getValue();
        if (!message.isValid()) {
            throw new MailboxInvalidMessageCreationException();
        }
        this.attachmentChecker.assertAttachmentsExist(entry, session);
    }

    @VisibleForTesting
    void assertIsUserOwnerOfMailboxes(List<MailboxId> mailboxIds, MailboxSession session) throws MailboxNotOwnedException {
        if (!this.allMailboxOwned(mailboxIds, session)) {
            throw new MailboxNotOwnedException();
        }
    }

    private boolean allMailboxOwned(List<MailboxId> mailboxIds, MailboxSession session) {
        FunctionChainer findMailbox = Throwing.function(mailboxId -> this.mailboxManager.getMailbox(mailboxId, session));
        return mailboxIds.stream().map(findMailbox.sneakyThrow()).map(Throwing.function(MessageManager::getMailboxPath)).allMatch(path -> path.belongsTo(session));
    }

    private ValueWithId.MessageWithId handleOutboxMessages(ValueWithId.CreationMessageEntry entry, MailboxSession session) throws MailboxException, MessagingException, IOException {
        this.assertUserCanSendFrom(session.getUser(), ((CreationMessage)entry.getValue()).getFrom());
        MessageFullViewFactory.MetaDataWithContent newMessage = this.messageAppender.appendMessageInMailboxes(entry, (List<MailboxId>)this.toMailboxIds(entry), session);
        MessageFullView jmapMessage = (MessageFullView)this.messageFullViewFactory.fromMetaDataWithContent(newMessage).block();
        Envelope envelope = EnvelopeUtils.fromMessage(jmapMessage);
        this.messageSender.sendMessage(newMessage, envelope, session);
        this.referenceUpdater.updateReferences((Map<String, String>)((CreationMessage)entry.getValue()).getHeaders(), session);
        return new ValueWithId.MessageWithId(entry.getCreationId(), jmapMessage);
    }

    @VisibleForTesting
    void assertUserCanSendFrom(Username connectedUser, Optional<CreationMessage.DraftEmailer> from) throws MailboxSendingNotAllowedException {
        Optional<Username> maybeFromUser = from.flatMap(CreationMessage.DraftEmailer::getEmail).map(Username::of);
        if (!this.canSendMailUsingIdentity(connectedUser, maybeFromUser)) {
            String allowedSender = connectedUser.asString();
            throw new MailboxSendingNotAllowedException(connectedUser, maybeFromUser);
        }
        LOG.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), from);
    }

    private boolean canSendMailUsingIdentity(Username connectedUser, Optional<Username> maybeFromUser) {
        return maybeFromUser.filter(fromUser -> this.canSendFrom.userCanSendFrom(connectedUser, fromUser)).isPresent();
    }

    private ValueWithId.MessageWithId handleDraftMessages(ValueWithId.CreationMessageEntry entry, MailboxSession session) throws MailboxException, MessagingException, IOException {
        MessageFullViewFactory.MetaDataWithContent newMessage = this.messageAppender.appendMessageInMailboxes(entry, (List<MailboxId>)this.toMailboxIds(entry), session);
        MessageFullView jmapMessage = (MessageFullView)this.messageFullViewFactory.fromMetaDataWithContent(newMessage).block();
        return new ValueWithId.MessageWithId(entry.getCreationId(), jmapMessage);
    }

    private boolean isAppendToMailboxWithRole(Role role, CreationMessage entry, MailboxSession mailboxSession) throws MailboxException {
        return this.getMailboxWithRole(mailboxSession, role).map(entry::isOnlyIn).orElse(false);
    }

    private boolean isTargettingAMailboxWithRole(Role role, CreationMessage entry, MailboxSession mailboxSession) throws MailboxException {
        return this.getMailboxWithRole(mailboxSession, role).map(entry::isIn).orElse(false);
    }

    private Optional<MessageManager> getMailboxWithRole(MailboxSession mailboxSession, Role role) throws MailboxException {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, mailboxSession.getUser())).toStream().findFirst();
    }

    private SetError buildSetErrorFromValidationResult(List<ValidationResult> validationErrors) {
        return SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(this.collectMessageProperties(validationErrors)).description(this.formatValidationErrorMessge(validationErrors)).build();
    }

    private String formatValidationErrorMessge(List<ValidationResult> validationErrors) {
        return validationErrors.stream().map(err -> err.getProperty() + ": " + err.getErrorMessage()).collect(Collectors.joining("\\n"));
    }

    private Set<MessageProperties.MessageProperty> collectMessageProperties(List<ValidationResult> validationErrors) {
        Splitter propertiesSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return validationErrors.stream().flatMap(err -> propertiesSplitter.splitToList((CharSequence)err.getProperty()).stream()).flatMap(MessageProperties.MessageProperty::find).collect(Collectors.toSet());
    }
}

